/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import twaver.Element;
import twaver.GeoCoordinate;
import twaver.Link;
import twaver.Node;
import twaver.TDataBox;
import twaver.web.svg.network.MapNetwork;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.ui.ElementSVGUI;
import twaver.web.svg.network.ui.InterceptedLinkSVGUI;

public class TGISNetwork
extends MapNetwork {
    private double \u03d0;
    private double \u03ce;
    private double \u03cb;
    private double \u03ca;
    private int \u03cc;
    private int \u03c9;
    private double \u03c8;
    private double \u03c7;
    private Rectangle \u03cd;
    private Map \u03c6 = new HashMap();

    public TGISNetwork(TDataBox box, double latitudeNorth, double latitudeSouth, double longitudeEast, double longitudeWest) {
        super(box);
        this.backgroundFillOpacity = 0.0f;
        this.exportBackground = false;
    }

    protected void calculateCoordinate(Element element) {
        if (this.\u03c6.get(element) == null) {
            GeoCoordinate coord;
            if (element instanceof Link) {
                Link link = (Link)element;
                Node from = link.getFromAgent();
                Node to = link.getToAgent();
                this.calculateCoordinate(from);
                this.calculateCoordinate(to);
            }
            if ((coord = element.getGeoCoordinate()) != null) {
                double longitude = coord.getLongitude();
                double latitude = coord.getLatitude();
                double x = (longitude - this.\u03cb) / this.\u03d0;
                double y = (this.\u03ca - latitude) / this.\u03ce;
                element.setCenterLocation(x, y);
            }
            this.\u03c6.put(element, Boolean.TRUE);
        }
    }

    protected boolean isElementInViewPort(Element element) {
        GeoCoordinate coord = element.getGeoCoordinate();
        if (coord != null) {
            double latitude = coord.getLatitude();
            double longitude = coord.getLongitude();
            if (longitude < this.\u03cb || longitude > this.\u03c8 || latitude > this.\u03ca || latitude < this.\u03c7) {
                return false;
            }
        }
        return true;
    }

    protected boolean isOutput(Element element) {
        if (this.isElementInViewPort(element)) {
            this.calculateCoordinate(element);
            return true;
        }
        return false;
    }

    public int[] getNetworkViewPortSize(SVGContext context) {
        return new int[]{this.\u03cc, this.\u03c9};
    }

    public void setNetworkParams(int viewWidth, int viewHeight, double mminx, double mminy, double radioX, double radioY) {
        this.\u03cc = viewWidth;
        this.\u03c9 = viewHeight;
        this.\u03cb = mminx;
        this.\u03ca = mminy;
        this.\u03d0 = radioX;
        this.\u03ce = radioY;
        this.\u03c8 = mminx + (double)viewWidth * radioX;
        this.\u03c7 = mminy - (double)viewHeight * radioY;
        this.\u03cd = new Rectangle(viewWidth, viewHeight);
    }

    public ElementSVGUI getElementSVGUI(Element element) {
        ElementSVGUI ui = (ElementSVGUI)this.elementUIs.get(element);
        if (ui == null) {
            if (element instanceof Link) {
                ui = new InterceptedLinkSVGUI(this, (Link)element);
                this.elementUIs.put(element, ui);
                return ui;
            }
            return super.getElementSVGUI(element);
        }
        return ui;
    }

    public String toSVG(SVGContext context) {
        this.\u03c6.clear();
        return super.toSVG(context);
    }

    public Rectangle getViewport() {
        return this.\u03cd;
    }
}

