/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class DoubleEditor
extends AbstractCellEditor {
    public DoubleEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public DoubleEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        try {
            return new Double(Double.parseDouble(value.toString()));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof Double;
    }
}

