/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.zoom;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import twaver.ZoomListener;
import twaver.base.A.E.m;
import twaver.network.TNetwork;
import twaver.network.zoom.Zoomer;

public class PhysicalZoomer
implements Zoomer {
    private TNetwork E = null;
    private double F = -1.0;
    private double B = -1.0;
    private double D = 1.0;
    private double A = 60.0;
    private double G = 0.01;
    private List C = new ArrayList();

    public double getMaxZoom() {
        return this.A;
    }

    public void setMaxZoom(double maxZoom) {
        this.A = maxZoom;
        if (this.getZoom() > this.A) {
            this.setZoom(this.A);
        }
    }

    public double getMinZoom() {
        return this.G;
    }

    public void setMinZoom(double minZoom) {
        this.G = minZoom;
        if (this.getZoom() < this.G) {
            this.setZoom(this.G);
        }
    }

    public void addZoomListener(ZoomListener l2) {
        if (l2 != null && this.C.contains(l2)) {
            this.C.remove(l2);
        }
        this.C.add(l2);
    }

    public void removeZoomListener(ZoomListener l2) {
        if (l2 != null) {
            this.C.remove(l2);
        }
    }

    protected void fireZoomChangeEvent(double oldValue, double newValue) {
        Iterator it = this.C.iterator();
        while (it.hasNext()) {
            ZoomListener l2 = (ZoomListener)it.next();
            l2.zoomChanged(oldValue, newValue);
        }
    }

    public PhysicalZoomer(TNetwork network) {
        this.E = network;
    }

    public double getZoom() {
        return this.D;
    }

    public void setZoom(double zoom) {
        if (zoom < this.G || zoom > this.A || zoom == this.D) {
            return;
        }
        this.E.saveCurrentBrowserRecord();
        Point centerPoint = this.E.getLogicalCenterPoint();
        double oldValue = this.D;
        this.D = zoom;
        this.E.adjustCanvasSize();
        this.E.getCanvasScrollPane().revalidate();
        this.E.setLogicalCenterPoint(centerPoint);
        this.E.getCanvas().repaint();
        this.fireZoomChangeEvent(oldValue, zoom);
    }

    public TNetwork getNetwork() {
        return this.E;
    }

    public void zoomIn() {
        this.setZoom(this.D * this.getZoomIncrement());
    }

    public void zoomOut() {
        this.setZoom(this.D / this.getZoomIncrement());
    }

    public void wheelZoomIn() {
        this.setZoom(this.D * this.getWheelZoomIncrement());
    }

    public void wheelZoomOut() {
        this.setZoom(this.D / this.getWheelZoomIncrement());
    }

    public void zoomReset() {
        this.setZoom(1.0);
    }

    public void zoomToRect(Rectangle rect) {
        double yFactor;
        if (rect == null) {
            return;
        }
        JViewport viewport = this.E.getCanvasScrollPane().getViewport();
        double xFactor = (double)viewport.getWidth() / rect.getWidth();
        double factor = xFactor < (yFactor = (double)viewport.getHeight() / rect.getHeight()) ? xFactor : yFactor;
        double x = rect.getX() + rect.getWidth() / 2.0;
        double y = rect.getY() + rect.getHeight() / 2.0;
        x = x / this.getZoom() * (factor *= this.getZoom());
        y = y / this.getZoom() * factor;
        this.setZoom(factor);
        viewport.setViewPosition(new Point((int)(x -= (double)(viewport.getWidth() / 2)), (int)(y -= (double)(viewport.getHeight() / 2))));
    }

    public void zoomBack() {
        this.E.zoomBack();
    }

    public void zoomToOverview() {
        this.zoomToOverview(0, 0);
    }

    public void zoomToOverview(int gapX, int gapY) {
        Rectangle viewRect = this.E.getCanvasScrollPane().getViewport().getViewRect();
        if (viewRect.width == 0 || viewRect.height == 0) {
            this.A(gapX, gapY, 0);
        }
        Dimension size = this.E.getLogicalSize();
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        size.width += gapX;
        size.height += gapY;
        double xFactor = (double)size.width / viewRect.getWidth();
        double yFactor = (double)size.height / viewRect.getHeight();
        double factor = 1.0 / Math.max(xFactor, yFactor);
        this.setZoom(factor);
    }

    private void A(final int gapX, final int gapY, final int count) {
        if (count < 5) {
            Rectangle viewRect = this.E.getCanvasScrollPane().getViewport().getViewRect();
            if (viewRect.width != 0 && viewRect.height != 0) {
                this.zoomToOverview(gapX, gapY);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PhysicalZoomer.this.A(gapX, gapY, count + 1);
                    }
                });
            }
        }
    }

    public double getWheelZoomIncrement() {
        if (this.B <= 0.0) {
            return m.C(this.E, "network.wheel.zoom.increment");
        }
        return this.B;
    }

    public void setWheelZoomIncrement(double wheelZoomIncrement) {
        this.B = wheelZoomIncrement;
    }

    public double getZoomIncrement() {
        if (this.F <= 0.0) {
            return m.C(this.E, "network.zoom.increment");
        }
        return this.F;
    }

    public void setZoomIncrement(double zoomIncrement) {
        this.F = zoomIncrement;
    }
}

