/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twaver.PolyLine;
import twaver.Segment;
import twaver.base.A.D.A.B;
import twaver.base.A.E.D;
import twaver.base.A.E.n;
import twaver.network.TNetwork;
import twaver.network.ui.LinkUI;

public class PolyLineUI
extends LinkUI {
    protected Map colorSegmentMap = new HashMap(1);
    protected Map blinkingSegmentMap = new HashMap(1);
    protected PolyLine polyLine;
    private Rectangle G = null;

    public PolyLineUI(TNetwork network, PolyLine polyLine) {
        super(network, polyLine);
        this.polyLine = polyLine;
    }

    public void paint(Graphics2D g2d) {
        Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.antialias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Composite oldComposite = null;
        if (this.renderAlpha != 1.0f) {
            oldComposite = g2d.getComposite();
            AlphaComposite composite = AlphaComposite.getInstance(3, this.renderAlpha);
            g2d.setComposite(composite);
        }
        this.paintBorder(g2d);
        this.paintBody(g2d);
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
        this.paintAttachments(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
    }

    private boolean C() {
        if (this.isBodyDark()) {
            return true;
        }
        return this.polyLine.getBlinkingObject() != null && B.B();
    }

    public void paintBody(Graphics2D g2d) {
        Shape shape;
        Iterator it;
        Color oldColor;
        n.A(this.getShape(), g2d, this);
        if (!this.blinkingSegmentMap.isEmpty()) {
            if (this.C()) {
                g2d.setXORMode(this.blinkColor);
            }
            oldColor = this.color;
            it = this.blinkingSegmentMap.keySet().iterator();
            while (it.hasNext()) {
                shape = (Shape)it.next();
                this.color = (Color)this.blinkingSegmentMap.get(shape);
                n.A(shape, g2d, this);
            }
            this.color = oldColor;
            if (this.C()) {
                g2d.setPaintMode();
            }
        }
        if (!this.colorSegmentMap.isEmpty()) {
            oldColor = this.color;
            it = this.colorSegmentMap.keySet().iterator();
            while (it.hasNext()) {
                shape = (Shape)it.next();
                this.color = (Color)this.colorSegmentMap.get(shape);
                n.A(shape, g2d, this);
            }
            this.color = oldColor;
        }
    }

    public void invalidateShape() {
        if (this.network.isFrozeLinkShape() || this.polyLine.isShapeFrozen()) {
            return;
        }
        this.G = null;
        super.invalidateShape();
    }

    public Rectangle getUIBounds() {
        if (this.G != null) {
            return (Rectangle)this.G.clone();
        }
        List segments = this.polyLine.getOrderSegments();
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            Point toLocation;
            Point fromLocation;
            Segment segment = (Segment)segments.get(i2);
            if (!segment.isVisible() || (fromLocation = segment.getFromLocation()) == null || (toLocation = segment.getToLocation()) == null) continue;
            if (this.G == null) {
                this.G = new Rectangle(fromLocation);
                this.G.add(toLocation);
                continue;
            }
            this.G.add(fromLocation);
            this.G.add(toLocation);
        }
        if (this.G != null) {
            int g2 = (this.getLinkWidth() + this.getOutlineWidth()) / 2;
            this.G.grow(g2, g2);
        }
        return this.G;
    }

    public Shape getShape() {
        if (this.shape == null) {
            GeneralPath path = this.getPath();
            int linkWidth = this.getLinkWidth();
            if (linkWidth <= 1) {
                this.shape = path;
            } else {
                Stroke stroke = this.getStroke();
                this.shape = stroke.createStrokedShape(path);
            }
        }
        return this.shape;
    }

    public Segment getSegmentLogicalAt(int x, int y) {
        Rectangle bounds = this.network.getElementBounds(this.element);
        if (bounds != null && !bounds.contains(x, y)) {
            return null;
        }
        List segments = this.polyLine.getSegments();
        int width = this.getLinkWidth() / 2 + 1;
        if (width < 3) {
            width = 3;
        }
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            Point toLocation;
            Point fromLocation;
            Segment segment = (Segment)segments.get(i2);
            if (!segment.isVisible() || (fromLocation = segment.getFromLocation()) == null || (toLocation = segment.getToLocation()) == null || !D.A(x, y, fromLocation.x, fromLocation.y, toLocation.x, toLocation.y, width)) continue;
            return segment;
        }
        return null;
    }

    public Segment getSegmentPhysicalAt(int x, int y) {
        double zoom = this.network.getZoomer().getZoom();
        return this.getSegmentLogicalAt((int)((double)x / zoom), (int)((double)y / zoom));
    }

    public GeneralPath getPath() {
        if (this.path != null) {
            return this.path;
        }
        this.path = new GeneralPath();
        this.colorSegmentMap.clear();
        this.blinkingSegmentMap.clear();
        List segments = this.polyLine.getOrderSegments();
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            Point toLocation;
            Point fromLocation;
            Segment segment = (Segment)segments.get(i2);
            if (!segment.isVisible() || (fromLocation = segment.getFromLocation()) == null || (toLocation = segment.getToLocation()) == null) continue;
            this.path.moveTo(fromLocation.x, fromLocation.y);
            this.path.lineTo(toLocation.x, toLocation.y);
            if (this.polyLine.isBlinking(segment)) {
                Color segmentColor = segment.getLineColor();
                if (segmentColor == null) {
                    segmentColor = this.color;
                }
                Shape line = new Line2D.Double(fromLocation.getX(), fromLocation.getY(), toLocation.getX(), toLocation.getY());
                if (this.getLinkWidth() > 1) {
                    line = this.getStroke().createStrokedShape(line);
                }
                this.blinkingSegmentMap.put(line, segmentColor);
                continue;
            }
            if (segment.getLineColor() == null) continue;
            Shape line = new Line2D.Double(fromLocation.getX(), fromLocation.getY(), toLocation.getX(), toLocation.getY());
            if (this.getLinkWidth() > 1) {
                line = this.getStroke().createStrokedShape(line);
            }
            this.colorSegmentMap.put(line, segment.getLineColor());
        }
        return this.path;
    }

    public void paintBorder(Graphics2D g2d) {
        if (this.polyLine.getBlinkingObject() == null) {
            super.paintBorder(g2d);
        }
    }

    public boolean isBundledHidden() {
        return false;
    }

    public void installAttachments() {
    }

    public void performAction(int gesture, MouseEvent e2) {
    }

    protected void paintArrows(Graphics2D g2d) {
    }

    public int getBundleIndex() {
        return 0;
    }

    public boolean isBundleExpand() {
        return true;
    }

    public void reverseExpand(boolean informOthers) {
    }

    public void setBundleExpand(boolean bundleExpand, boolean informOthers) {
    }

    public boolean isBundleAgent() {
        return true;
    }
}

