/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import twaver.network.InteractionMode;
import twaver.network.TNetwork;
import twaver.network.inputhandler.CreateLinkInputHandler;
import twaver.network.inputhandler.CreateNodeInputHandler;
import twaver.network.inputhandler.CreatePolyInputHandler;
import twaver.network.inputhandler.CreateShapeLinkInputHandler;
import twaver.network.inputhandler.DefaultInputHandler;
import twaver.network.inputhandler.EagerMoveInputHandler;
import twaver.network.inputhandler.InputHandler;
import twaver.network.inputhandler.InteractionInputHandler;
import twaver.network.inputhandler.LazyMoveInputHandler;
import twaver.network.inputhandler.MagnifierInputHandler;
import twaver.network.inputhandler.PanInputHandler;
import twaver.network.inputhandler.PopupMenuInputHandler;
import twaver.network.inputhandler.ResizeInputHandler;
import twaver.network.inputhandler.SelectionInputHandler;
import twaver.network.inputhandler.ZoomToRectInputHandler;

public class InteractionModeFactory {
    public static InteractionMode getCreateLinkMode(TNetwork network, Class linkclass) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new CreateLinkInputHandler(network, linkclass)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getCreatePolyMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new CreatePolyInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getCreateShapeLinkMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new CreateShapeLinkInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getCreateNodeMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new CreateNodeInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getCreateNodeMode(TNetwork network, Class elementType) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new CreateNodeInputHandler(network, elementType)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getPanMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new PanInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getMagnifierMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new ResizeInputHandler(network), new SelectionInputHandler(network), new EagerMoveInputHandler(network), new InteractionInputHandler(network), new MagnifierInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getZoomToRectMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new ZoomToRectInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getDefaultMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new ResizeInputHandler(network), new SelectionInputHandler(network), new EagerMoveInputHandler(network), new InteractionInputHandler(network), new PopupMenuInputHandler(network)};
        return new InteractionMode(listeners);
    }

    public static InteractionMode getDefaultLazySelectionMode(TNetwork network) {
        InputHandler[] listeners = new InputHandler[]{new DefaultInputHandler(network), new ResizeInputHandler(network), new SelectionInputHandler(network), new LazyMoveInputHandler(network), new InteractionInputHandler(network), new PopupMenuInputHandler(network)};
        return new InteractionMode(listeners);
    }
}

