/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.textfield.number;

import com.nepxion.swing.locale.SwingLocale;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberDocument
extends PlainDocument {
    public static final int MAXIMUM_LENGTH = 16;
    public static final int DECIMAL_LENGTH = 0;
    private int maximumLength;
    private int decimalLength;
    private double minimumValue;
    private double maximumValue;

    public NumberDocument() {
        this(Double.MIN_VALUE);
    }

    public NumberDocument(double minimumValue) {
        this(minimumValue, Double.MAX_VALUE);
    }

    public NumberDocument(int maximumLength, int decimalLength) {
        this(maximumLength, decimalLength, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public NumberDocument(double minimumValue, double maximumValue) {
        this(16, 0, minimumValue, maximumValue);
    }

    public NumberDocument(int maximumLength, int decimalLength, double minimumValue, double maximumValue) {
        if (maximumLength < 0 || decimalLength < 0) {
            throw new IllegalArgumentException(SwingLocale.getString("length_not_less_than_0"));
        }
        if (minimumValue >= maximumValue) {
            throw new IllegalArgumentException(SwingLocale.getString("minimum_value_not_more_than_or_equal_maximum_value"));
        }
        this.maximumLength = maximumLength;
        this.decimalLength = decimalLength;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    @Override
    public void insertString(int offset, String value, AttributeSet attributeSet) throws BadLocationException {
        int length = this.getLength();
        String text = this.getText(0, length);
        int decimalIndex = text.indexOf(".");
        if (value.equals("F") || value.equals("f") || value.equals("D") || value.equals("d") || (text + value).length() > this.maximumLength || decimalIndex > -1 && offset > decimalIndex && (text.substring(decimalIndex + 1) + value).length() > this.decimalLength || text.trim().equals("0") && !value.substring(0, 1).equals(".") && offset != 0 || value.equals(".") && this.decimalLength == 0 || value.indexOf(".") > -1 && value.substring(value.indexOf(".") + 1).length() > this.decimalLength) {
            Toolkit.getDefaultToolkit().beep();
            throw new NumberFormatException(SwingLocale.getString("invalid_data_format"));
        }
        try {
            text = text.substring(0, offset) + value + text.substring(offset, length);
            if (!text.equals("-")) {
                double doubleValue = Double.parseDouble(text);
                if (doubleValue < this.minimumValue || doubleValue > this.maximumValue) {
                    Toolkit.getDefaultToolkit().beep();
                    throw new IllegalArgumentException(SwingLocale.getString("data_overflow") + " [" + this.minimumValue + ", " + this.maximumValue + "]");
                }
            } else if (this.minimumValue >= 0.0) {
                Toolkit.getDefaultToolkit().beep();
                throw new NumberFormatException(SwingLocale.getString("invalid_data_format"));
            }
        }
        catch (NumberFormatException e) {
            Toolkit.getDefaultToolkit().beep();
            throw new NumberFormatException(SwingLocale.getString("invalid_data_format"));
        }
        super.insertString(offset, value, attributeSet);
    }
}

