/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.radiobutton;

import com.nepxion.swing.button.ButtonFocusListener;
import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.dialog.JBasicDialog;
import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.list.JBasicList;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.radiobutton.JRadioButtonListPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JRadioButtonSelector
extends JBasicDialog {
    private JRadioButtonListPanel radioButtonListPanel;
    private List allElementNodes;
    private boolean isConfirmed;

    public JRadioButtonSelector(Frame owner, String title) {
        this(owner, title, new Dimension(350, 320));
    }

    public JRadioButtonSelector(Dialog owner, String title) {
        this(owner, title, new Dimension(350, 320));
    }

    public JRadioButtonSelector(Frame owner, String title, Dimension dimension) {
        this(owner, title, dimension, null);
    }

    public JRadioButtonSelector(Dialog owner, String title, Dimension dimension) {
        this(owner, title, dimension, null);
    }

    public JRadioButtonSelector(Frame owner, String title, List allElementNodes) {
        this(owner, title, new Dimension(350, 320), allElementNodes);
    }

    public JRadioButtonSelector(Dialog owner, String title, List allElementNodes) {
        this(owner, title, new Dimension(350, 320), allElementNodes);
    }

    public JRadioButtonSelector(Frame owner, String title, Dimension dimension, List allElementNodes) {
        super(owner, title, dimension, true, false, true);
        this.allElementNodes = allElementNodes;
        this.initComponents();
    }

    public JRadioButtonSelector(Dialog owner, String title, Dimension dimension, List allElementNodes) {
        super(owner, title, dimension, true, false, true);
        this.allElementNodes = allElementNodes;
        this.initComponents();
    }

    private void initComponents() {
        this.radioButtonListPanel = new JRadioButtonListPanel(this.allElementNodes);
        JClassicButton confirmButton = new JClassicButton(SwingLocale.getString("yes"), IconFactory.getSwingIcon("stereo/confirm_16.png"), SwingLocale.getString("yes"));
        ActionListener confirmActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IElementNode selectedElementNode = JRadioButtonSelector.this.radioButtonListPanel.getSelectedElementNode();
                if (selectedElementNode == null) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame(JRadioButtonSelector.this), SwingLocale.getString("select_not_null"), SwingLocale.getString("warning"), 2);
                    return;
                }
                JRadioButtonSelector.this.setVisible(false);
                JRadioButtonSelector.this.isConfirmed = true;
            }
        };
        confirmButton.addFocusListener(new ButtonFocusListener(this));
        confirmButton.addActionListener(confirmActionListener);
        KeyStrokeManager.registerButtonToEnterKey(confirmButton, confirmActionListener);
        JClassicButton cancelButton = new JClassicButton(SwingLocale.getString("no"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("no"));
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonSelector.this.setVisible(false);
                JRadioButtonSelector.this.isConfirmed = false;
            }
        };
        cancelButton.addFocusListener(new ButtonFocusListener(this));
        cancelButton.addActionListener(cancelActionListener);
        KeyStrokeManager.registerButtonToEscapeKey(cancelButton, cancelActionListener);
        double[][] size = new double[][]{{-1.0, -2.0, 5.0, -2.0, -1.0}, {-1.0, 5.0, 30.0}};
        JPanel panel = new JPanel();
        panel.setLayout(new TableLayout(size));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.radioButtonListPanel, "0, 0, 4, 0");
        panel.add((Component)confirmButton, "1, 2");
        panel.add((Component)cancelButton, "3, 2");
        Container container = this.getContentPane();
        container.add(panel);
    }

    public JRadioButtonListPanel getRadioButtonListPanel() {
        return this.radioButtonListPanel;
    }

    public JBasicList getRadioButtonList() {
        return this.radioButtonListPanel.getList();
    }

    public IElementNode getSelectedElementNode() {
        return this.radioButtonListPanel.getSelectedElementNode();
    }

    public Object getSelectedUserObject() {
        return this.radioButtonListPanel.getSelectedUserObject();
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }
}

