/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class OvalBorder
implements Border {
    private int width = 6;
    private int height = 6;
    private Color topColor = Color.white;
    private Color bottomColor = Color.gray;

    public OvalBorder() {
        this.width = 6;
        this.height = 6;
    }

    public OvalBorder(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public OvalBorder(int width, int height, Color topColor, Color bottomColor) {
        this.width = width;
        this.height = height;
        this.topColor = topColor;
        this.bottomColor = bottomColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.height, this.width, this.height, this.width);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.setColor(this.topColor);
        g.drawLine(x, y + --h - this.height, x, y + this.height);
        g.drawArc(x, y, 2 * this.width, 2 * this.height, 180, -90);
        g.drawLine(x + this.width, y, x + --w - this.width, y);
        g.drawArc(x + w - 2 * this.width, y, 2 * this.width, 2 * this.height, 90, -90);
        g.setColor(this.bottomColor);
        g.drawLine(x + w, y + this.height, x + w, y + h - this.height);
        g.drawArc(x + w - 2 * this.width, y + h - 2 * this.height, 2 * this.width, 2 * this.height, 0, -90);
        g.drawLine(x + this.width, y + h, x + w - this.width, y + h);
        g.drawArc(x, y + h - 2 * this.height, 2 * this.width, 2 * this.height, -90, -90);
    }
}

