/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.border.Border;

public class BalloonBorder
implements Border {
    private Dimension lastComponentSize;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Color fillColor;
    private int offset;

    public BalloonBorder(Color fillColor, int offset) {
        this.fillColor = fillColor;
        this.offset = offset;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Dimension currentComponent = c.getSize();
        if (currentComponent.equals(this.lastComponentSize)) {
            return this.insets;
        }
        this.insets = new Insets(1, 1, this.offset + 1, 1);
        this.lastComponentSize = currentComponent;
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        width -= this.insets.left + this.insets.right;
        height -= this.insets.top + this.insets.bottom;
        Point startPoint = new Point();
        Point endPoint = new Point();
        startPoint.x = x;
        startPoint.y = y;
        endPoint.x = x + width + 1;
        endPoint.y = y;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        startPoint.setLocation(endPoint);
        endPoint.x = x + width + 1;
        endPoint.y = y + height + 1;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        startPoint.setLocation(endPoint);
        endPoint.x = x + this.offset * 2;
        endPoint.y = y + height + 1;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        startPoint.setLocation(endPoint);
        endPoint.x = x + this.offset;
        endPoint.y = y + height + this.offset + 1;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        startPoint.setLocation(endPoint);
        endPoint.x = x + this.offset;
        endPoint.y = y + height + 1;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        startPoint.setLocation(endPoint);
        endPoint.x = x;
        endPoint.y = y + height + 1;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        startPoint.setLocation(endPoint);
        endPoint.x = x;
        endPoint.y = y;
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        int[] xPoints = new int[]{x + this.offset + 1, x + this.offset * 2, x + this.offset + 1};
        int[] yPoints = new int[]{y + height + 1, y + height + 1, y + height + this.offset};
        g.setColor(this.fillColor);
        g.fillPolygon(xPoints, yPoints, 3);
    }
}

