/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.internalframe;

import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.checkbox.JCheckBoxSelector;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class InternalFrameManager {
    public static void showCloseDialog(JDesktopPane desktopPane, JCheckBoxSelector checkBoxSelector) {
        if (desktopPane == null) {
            return;
        }
        JInternalFrame[] internalFrames = desktopPane.getAllFrames();
        if (internalFrames.length == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(desktopPane), SwingLocale.getString("no_close_item"), SwingLocale.getString("warning"), 2);
            return;
        }
        Vector<ElementNode> slectionElementNodes = new Vector<ElementNode>();
        for (int i = 0; i < internalFrames.length; ++i) {
            JInternalFrame internalFrame = internalFrames[i];
            String title = internalFrame.getTitle();
            String toolTipText = internalFrame.getToolTipText();
            Icon icon = internalFrame.getFrameIcon();
            JComponent component = internalFrame.isIcon() ? internalFrame.getDesktopIcon() : internalFrame;
            ElementNode elementNode = new ElementNode(title, title, icon, toolTipText, (Object)component);
            slectionElementNodes.add(elementNode);
        }
        if (checkBoxSelector == null) {
            checkBoxSelector = new JCheckBoxSelector(HandleManager.getFrame(desktopPane), SwingLocale.getString("select_close"));
        }
        checkBoxSelector.getCheckBoxList().setListData(slectionElementNodes);
        checkBoxSelector.setVisible(true);
        checkBoxSelector.dispose();
        if (checkBoxSelector.isConfirmed()) {
            List selectedComponents = checkBoxSelector.getSelectedUserObjects();
            for (Component component : selectedComponents) {
                desktopPane.remove(component);
            }
            ContainerManager.update(desktopPane);
        }
    }
}

