/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.pie;

import com.nepxion.swing.chart.JChartFactory;
import com.nepxion.swing.chart.JChartPanel;
import com.nepxion.swing.chart.pie.IPieChartPlot;
import com.nepxion.swing.chart.pie.PieChartPlot;
import com.nepxion.swing.chart.pie.PieChartPlot3D;
import com.nepxion.swing.locale.SwingLocale;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;

public class PieChartFactory {
    public static PiePlot createPiePlot(PieDataset pieDataset, String toolTipText, String legendToolTipText, boolean isParticularLabel) {
        PiePlot piePlot = PieChartFactory.createPiePlot(pieDataset, false, false, false);
        PieChartFactory.setPiePlotPreference(piePlot, toolTipText, legendToolTipText, isParticularLabel);
        return piePlot;
    }

    public static PiePlot createPiePlot(PieDataset pieDataset, boolean labels, boolean tooltips, boolean urls) {
        PieChartPlot piePlot = new PieChartPlot(pieDataset);
        if (labels) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        }
        if (tooltips) {
            piePlot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        }
        if (urls) {
            piePlot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator());
        }
        return piePlot;
    }

    public static PiePlot createPiePlot3D(PieDataset pieDataset, String toolTipText, String legendToolTipText, boolean isParticularLabel) {
        PiePlot piePlot = PieChartFactory.createPiePlot3D(pieDataset, false, false, false);
        PieChartFactory.setPiePlotPreference(piePlot, toolTipText, legendToolTipText, isParticularLabel);
        return piePlot;
    }

    public static PiePlot createPiePlot3D(PieDataset pieDataset, boolean labels, boolean tooltips, boolean urls) {
        PieChartPlot3D piePlot = new PieChartPlot3D(pieDataset);
        if (labels) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        }
        if (tooltips) {
            piePlot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        }
        if (urls) {
            piePlot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator());
        }
        return piePlot;
    }

    public static void setPiePlotPreference(PiePlot piePlot, String toolTipText, String legendToolTipText, boolean isParticularLabel) {
        piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(isParticularLabel ? "{0} : {2}, {1}" : "{1}", NumberFormat.getNumberInstance(), (NumberFormat)new DecimalFormat("0.00%")));
        piePlot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} : " + toolTipText + " [{1}], " + SwingLocale.getString("percent") + " [{2}], " + SwingLocale.getString("total") + " [{3}]", NumberFormat.getNumberInstance(), (NumberFormat)new DecimalFormat("0.00%")));
        piePlot.setLegendLabelToolTipGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(legendToolTipText + " - {0}"));
        piePlot.setInsets(new RectangleInsets(4.0, 8.0, 0.0, 8.0));
        piePlot.setDirection(Rotation.ANTICLOCKWISE);
        piePlot.setStartAngle(270.0);
        piePlot.setForegroundAlpha(0.75f);
        piePlot.setSimpleLabels(false);
        piePlot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.gray, 0.0f, 0.0f, new Color(251, 251, 251), true));
    }

    public static Comparable getPiePlotSelectionKey(JChartPanel chartPanel) {
        JFreeChart chart = chartPanel.getChart();
        return PieChartFactory.getPiePlotSelectionKey(chart);
    }

    public static Comparable getPiePlotSelectionKey(JFreeChart chart) {
        Plot plot = chart.getPlot();
        if (plot instanceof IPieChartPlot) {
            IPieChartPlot pieChartPlot = (IPieChartPlot)plot;
            Comparable key = pieChartPlot.getSelectionKey();
            return key;
        }
        return null;
    }

    public static void setSectionPaint(PiePlot piePlot) {
        int colorIndex = 0;
        for (Comparable key : piePlot.getDataset().getKeys()) {
            PieChartFactory.setSectionPaint(piePlot, key, colorIndex);
            ++colorIndex;
        }
    }

    public static void setSectionPaint(PiePlot piePlot, Comparable key, int colorIndex) {
        Paint paint = JChartFactory.getPaint(colorIndex);
        piePlot.setSectionPaint(key, paint);
    }
}

