/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import twaver.Element;
import twaver.Link;
import twaver.Node;
import twaver.TWaverUtil;
import twaver.base.A.E.D;
import twaver.network.CanvasMarker;
import twaver.network.DraggingSpeed;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public class CreateLinkInputHandler
extends InputAdapter
implements CanvasMarker {
    protected Class elementType = null;
    protected TNetwork network = null;
    protected Node fromNode = null;
    protected Node toNode = null;
    private Point M = null;
    private Point K = null;
    private Point L = null;

    public CreateLinkInputHandler(TNetwork network) {
        this(network, Link.class);
    }

    public CreateLinkInputHandler(TNetwork network, Class elementType) {
        this.network = network;
        this.elementType = elementType;
    }

    public void mousePressed(MouseEvent e2) {
        if (!SwingUtilities.isLeftMouseButton(e2)) {
            return;
        }
        this.M = e2.getPoint();
        this.M.x = (int)((double)this.M.x / this.network.getZoomer().getZoom());
        this.M.y = (int)((double)this.M.y / this.network.getZoomer().getZoom());
        Element element = this.network.getElementLogicalAt(this.M);
        if (element == null) {
            return;
        }
        if (!(element instanceof Node)) {
            return;
        }
        if (!this.isLegalFromNode((Node)element)) {
            return;
        }
        this.network.addCanvasMarker(this);
        this.network.clearSelection();
        this.network.appendSelection(element);
        this.fromNode = (Node)element;
        this.L = this.fromNode.getCenterLocation();
    }

    protected boolean isLegalFromNode(Node fromNode) {
        return true;
    }

    protected boolean isLegalToNode(Node toNode) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent e2) {
        if (this.fromNode == null) {
            return;
        }
        DraggingSpeed.adjustCanvas(e2.getPoint(), this.network);
        this.M = e2.getPoint();
        this.M.x = (int)((double)this.M.x / this.network.getZoomer().getZoom());
        this.M.y = (int)((double)this.M.y / this.network.getZoomer().getZoom());
        try {
            Element element;
            this.A();
            if (this.toNode != null) {
                this.network.removeSelection(this.toNode);
            }
            if ((element = this.network.getElementLogicalAt(this.M)) == null || !(element instanceof Node) || !this.isLegalToNode((Node)element)) {
                this.toNode = null;
                return;
            }
            this.toNode = (Node)element;
        }
        finally {
            this.A();
            this.K = this.M;
        }
    }

    protected Link createLink() {
        Link link = null;
        try {
            link = (Link)this.elementType.newInstance();
            link.setFrom(this.fromNode);
            link.setTo(this.toNode);
            this.preProcess(link);
            this.network.addElementToCurrentSubNetwork(link);
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
        }
        return link;
    }

    protected void preProcess(Link link) {
    }

    public void mouseReleased(MouseEvent e2) {
        if (this.fromNode != null && this.toNode != null) {
            this.createLink();
        }
        this.A();
        this.network.clearSelection();
        this.fromNode = null;
        this.toNode = null;
        this.K = null;
        this.M = null;
        this.L = null;
        this.network.removeCanvasMarker(this);
    }

    protected Class getLinkClass() {
        return this.elementType;
    }

    private void A() {
        if (this.K != null) {
            Rectangle rect = D.A(this.L, this.K);
            this.network.getRenderer().repaintLogicalBounds(rect);
        }
        if (this.toNode != null) {
            this.network.getRenderer().repaint(this.toNode);
        }
    }

    public void mark(Graphics2D g2) {
        if (this.L != null && this.K != null) {
            TWaverUtil.drawDashLine(g2, this.L, this.K, 1.0);
        }
        if (this.toNode != null) {
            TWaverUtil.drawDashShape(g2, this.network.getElementBounds(this.toNode));
        }
    }
}

