/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel.option;

import com.nepxion.swing.button.ButtonFocusListener;
import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.panel.option.OptionConstants;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class JOptionButtonPanel
extends JPanel
implements OptionConstants {
    private JPanel container;
    private JClassicButton confirmButton;
    private JClassicButton cancelButton;
    private JClassicButton applyButton;
    private JClassicButton closeButton;
    private int option;
    private String value;

    public JOptionButtonPanel() {
        this.initComponents();
    }

    public JOptionButtonPanel(int option) {
        this.initComponents();
        this.setOption(option);
    }

    private void initComponents() {
        this.container = new JPanel();
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalGlue());
        this.add(this.container);
        this.add(Box.createHorizontalGlue());
    }

    public int getOption() {
        return this.option;
    }

    public void setOption(int option) {
        this.container.removeAll();
        this.option = option;
        switch (option) {
            case 0: {
                this.initYesNoApplyOption();
                break;
            }
            case 1: {
                this.initYesNoOption();
                break;
            }
            case 2: {
                this.initCloseOption();
            }
        }
    }

    private void initYesNoApplyOption() {
        this.initYesNoOption();
        this.applyButton = new JClassicButton(SwingLocale.getString("apply"), IconFactory.getSwingIcon("stereo/application_16.png"), SwingLocale.getString("apply"));
        ActionListener applyActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionButtonPanel.this.doApply();
            }
        };
        this.applyButton.addFocusListener(new ButtonFocusListener(this));
        this.applyButton.addActionListener(applyActionListener);
        this.container.add(this.applyButton);
    }

    private void initYesNoOption() {
        this.confirmButton = new JClassicButton(SwingLocale.getString("yes"), IconFactory.getSwingIcon("stereo/confirm_16.png"), SwingLocale.getString("yes"));
        ActionListener confirmActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionButtonPanel.this.doConfirm();
            }
        };
        this.confirmButton.addFocusListener(new ButtonFocusListener(this));
        this.confirmButton.addActionListener(confirmActionListener);
        KeyStrokeManager.registerButtonToEnterKey(this.confirmButton, confirmActionListener);
        this.container.add(this.confirmButton);
        this.cancelButton = new JClassicButton(SwingLocale.getString("no"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("no"));
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionButtonPanel.this.doCancel();
            }
        };
        this.cancelButton.addFocusListener(new ButtonFocusListener(this));
        this.cancelButton.addActionListener(cancelActionListener);
        KeyStrokeManager.registerButtonToEscapeKey(this.cancelButton, cancelActionListener);
        this.container.add(this.cancelButton);
    }

    private void initCloseOption() {
        this.closeButton = new JClassicButton(SwingLocale.getString("close"), IconFactory.getSwingIcon("stereo/close_16.png"), SwingLocale.getString("close"));
        this.closeButton.addFocusListener(new ButtonFocusListener(this));
        ActionListener closeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionButtonPanel.this.doClose();
            }
        };
        this.closeButton.addActionListener(closeActionListener);
        KeyStrokeManager.registerButtonToEnterKey(this.closeButton, closeActionListener);
        KeyStrokeManager.registerButtonToEscapeKey(this.closeButton, closeActionListener);
        this.container.add(this.closeButton);
    }

    public JPanel getContainer() {
        return this.container;
    }

    public JClassicButton getConfirmButton() {
        return this.confirmButton;
    }

    public JClassicButton getCancelButton() {
        return this.cancelButton;
    }

    public JClassicButton getApplyButton() {
        return this.applyButton;
    }

    public JClassicButton getCloseButton() {
        return this.closeButton;
    }

    public void doConfirm() {
        this.value = null;
        if (this.confirm()) {
            this.hideParent();
            this.value = "confirm";
        }
    }

    public void doCancel() {
        this.value = null;
        if (this.cancel()) {
            this.hideParent();
            this.value = "cancel";
        }
    }

    public void doApply() {
        this.value = null;
        this.apply();
        this.value = "apply";
    }

    public void doClose() {
        this.value = null;
        if (this.close()) {
            this.hideParent();
            this.value = "close";
        }
    }

    private void hideParent() {
        Window window = HandleManager.getWindow(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    public String getValue() {
        return this.value;
    }

    public boolean confirm() {
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean apply() {
        return true;
    }

    public boolean close() {
        return true;
    }
}

