/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.layout.planar.PlanarInformation;

public class SelfLoopTool {
    private EdgeList a = new EdgeList();
    private PlanarInformation b;

    public SelfLoopTool(PlanarInformation planarInformation) {
        this.b = planarInformation;
    }

    public void hideSelfLoops() {
        Graph graph = this.b.getGraph();
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            if (edgeCursor.edge().isSelfLoop()) {
                this.a.push(edgeCursor.edge());
                graph.hide(edgeCursor.edge());
            }
            edgeCursor.next();
        }
    }

    public void reinsertSelfLoops() {
        Graph graph = this.b.getGraph();
        EdgeCursor edgeCursor = this.a.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.source().degree() == 0) {
                graph.unhide(edge);
                this.b.createReverse(edge);
                this.b.calcFaces();
                this.b.setOuterFace(this.b.faces().face());
            } else {
                Edge edge2 = null;
                EdgeCursor edgeCursor2 = edge.source().outEdges();
                while (edgeCursor2.ok()) {
                    if (edge2 == null) {
                        edge2 = edgeCursor2.edge();
                    }
                    if (this.b.faceOf(edgeCursor2.edge()).edges().size() == 1) {
                        edge2 = edgeCursor2.edge();
                    }
                    edgeCursor2.next();
                }
                graph.unhide(edge);
                this.b.splitFaceWithSelfLoop(edge2, edge);
                this.b.calcOrdering();
            }
            edgeCursor.next();
        }
    }
}

