/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.dockable;

import com.nepxion.swing.framework.dockable.JDockableTabbedPane;
import com.nepxion.swing.framework.dockable.JDockableView;
import com.nepxion.swing.splitpane.JBasicSplitPane;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;

public class JDockableSplitPane
extends JBasicSplitPane {
    private JDockableView dockableView;
    private Container dockableContainer;
    private boolean isMaximized = false;
    private int index;

    public JDockableSplitPane() {
    }

    public JDockableSplitPane(int newOrientation) {
        super(newOrientation);
    }

    public void add(Component pane, Object constraints) {
        this.setConstraints(pane, constraints);
        super.add(pane, constraints);
    }

    public void add(Component pane, Object constraints, int index) {
        this.setConstraints(pane, constraints);
        super.add(pane, constraints, index);
    }

    public Component insertPane(Component pane, Object constraints, int index) {
        this.setConstraints(pane, constraints);
        return super.insertPane(pane, constraints, index);
    }

    public void setPaneAt(Component pane, Object constraints, int index) {
        this.setConstraints(pane, constraints);
        super.setPaneAt(pane, constraints, index);
    }

    private void setConstraints(Component pane, Object constraints) {
        if (pane instanceof JDockableView) {
            ((JDockableView)pane).setConstraints(constraints);
        }
    }

    public void toggleView(Component contentPane) {
        this.initialize();
        if (!this.isMaximized) {
            this.index = this.indexOfPane(contentPane);
            if (this.dockableView != null) {
                this.dockableView.setContentPane(contentPane);
                this.dockableView.updateUI();
            } else if (this.dockableContainer != null) {
                this.dockableContainer.removeAll();
                this.dockableContainer.add(contentPane);
                this.dockableContainer.validate();
            }
        } else {
            this.insertPane(contentPane, this.index);
            if (this.dockableView != null) {
                this.dockableView.setContentPane((Component)((Object)this));
                this.dockableView.updateUI();
            } else if (this.dockableContainer != null) {
                this.dockableContainer.removeAll();
                this.dockableContainer.add((Component)((Object)this));
                this.dockableContainer.validate();
            }
        }
        this.isMaximized = !this.isMaximized;
    }

    public void toggleLayout() {
        this.initialize();
        if (this.isMaximized) {
            return;
        }
        List tabbedPanes = this.getTabbedPanes();
        this.removeAll();
        this.setOrientation(this.getOrientation() == 1 ? 0 : 1);
        for (JDockableTabbedPane tabbedPane : tabbedPanes) {
            tabbedPane.setTabPlacement(this.getOrientation() == 1 ? tabbedPane.getHorizontalTabPlacement() : tabbedPane.getVerticalTabPlacement());
            this.add((Component)((Object)tabbedPane));
        }
    }

    private void initialize() {
        Container container = this.getParent();
        if (container instanceof JDockableView) {
            if (this.dockableView == null) {
                this.dockableView = (JDockableView)this.getParent();
            }
        } else if (this.dockableContainer == null) {
            this.dockableContainer = this.getParent();
        }
    }

    public List getTabbedPanes() {
        ArrayList<Component> tabbedPanes = new ArrayList<Component>();
        for (int i = 0; i < this.getPaneCount(); ++i) {
            Component component = this.getPaneAt(i);
            if (!(component instanceof JDockableTabbedPane)) continue;
            tabbedPanes.add(component);
        }
        return tabbedPanes;
    }
}

