/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.context;

import com.nepxion.swing.button.ButtonContext;
import com.nepxion.swing.chart.ChartContext;
import com.nepxion.swing.context.UIContextConstants;
import com.nepxion.swing.font.FontContext;
import com.nepxion.swing.icon.IconContext;
import com.nepxion.swing.lookandfeel.LookAndFeelManager;
import com.nepxion.swing.popupmenu.PopupMenuContext;
import com.nepxion.swing.style.framework.StyleContext;
import com.nepxion.swing.topic.TopicContext;
import com.nepxion.util.context.AbstractContextRegister;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIContextRegister
extends AbstractContextRegister
implements UIContextConstants {
    private static Log log = LogFactory.getLog(UIContextRegister.class);
    protected Properties properties;

    public void initializeContext(Properties properties) {
        this.properties = properties;
        log.info((Object)"---- UI Context Initialization Start ----");
        this.initStyle();
        this.initDecorated();
        this.initFont();
        this.initPDF();
        this.initButtonUI();
        this.initPopupMenuTitle();
        this.initIconPath();
        this.initTopicComponent();
        this.initLookAndFeel();
        log.info((Object)"----- UI Context Initialization End -----");
    }

    public void initializeContext(URL codeBase, Properties properties) {
        this.initializeContext(properties);
    }

    private void initStyle() {
        String style = this.properties.getProperty("style");
        String customStyle = this.properties.getProperty("customStyle");
        if (!this.isValid(style) && !this.isValid(customStyle)) {
            style = "JPlasticStyle";
        }
        if (this.isValid(style)) {
            style = "com.nepxion.swing.style.framework." + style;
        }
        if (this.isValid(style)) {
            StyleContext.registerStyle(style);
        } else if (this.isValid(customStyle)) {
            StyleContext.registerStyle(customStyle);
        }
        log.info((Object)("Parameter - style : [" + style + "]"));
        log.info((Object)("Parameter - customStyle : [" + customStyle + "]"));
    }

    private void initDecorated() {
        String frameDecorated = this.properties.getProperty("frameDecorated");
        String dialogDecorated = this.properties.getProperty("dialogDecorated");
        boolean isFrameDecorated = false;
        boolean isDialogDecorated = false;
        if (this.isValid(frameDecorated)) {
            isFrameDecorated = frameDecorated.equals("true");
        }
        if (this.isValid(dialogDecorated)) {
            isDialogDecorated = dialogDecorated.equals("true");
        }
        StyleContext.registerFrameDecorated(isFrameDecorated);
        StyleContext.registerDialogDecorated(isDialogDecorated);
        log.info((Object)("Parameter - isFrameDecorated : [" + isFrameDecorated + "]"));
        log.info((Object)("Parameter - isDialogDecorated : [" + isDialogDecorated + "]"));
    }

    private void initFont() {
        String fontName = this.properties.getProperty("fontName");
        int fontStyle = -1;
        int fontSize = -1;
        if (!this.isValid(fontName)) {
            fontName = "Dialog";
        }
        try {
            fontStyle = Integer.parseInt(this.properties.getProperty("fontStyle"));
            fontSize = Integer.parseInt(this.properties.getProperty("fontSize"));
        }
        catch (Exception e) {
            fontStyle = 0;
            fontSize = 12;
        }
        String chartTitleFontName = this.properties.getProperty("chartTitleFontName");
        int chartTitleFontStyle = -1;
        int chartTitleFontSize = -1;
        if (!this.isValid(chartTitleFontName)) {
            chartTitleFontName = "SimHei";
        }
        try {
            chartTitleFontStyle = Integer.parseInt(this.properties.getProperty("chartTitleFontStyle"));
            chartTitleFontSize = Integer.parseInt(this.properties.getProperty("chartTitleFontSize"));
        }
        catch (Exception e) {
            chartTitleFontStyle = 0;
            chartTitleFontSize = 18;
        }
        String chartSubTitleFontName = this.properties.getProperty("chartSubTitleFontName");
        int chartSubTitleFontStyle = -1;
        int chartSubTitleFontSize = -1;
        if (!this.isValid(chartSubTitleFontName)) {
            chartSubTitleFontName = "Dialog";
        }
        try {
            chartSubTitleFontStyle = Integer.parseInt(this.properties.getProperty("chartSubTitleFontStyle"));
            chartSubTitleFontSize = Integer.parseInt(this.properties.getProperty("chartSubTitleFontSize"));
        }
        catch (Exception e) {
            chartSubTitleFontStyle = 0;
            chartSubTitleFontSize = 12;
        }
        String chartLabelFontName = this.properties.getProperty("chartLabelFontName");
        int chartLabelFontStyle = -1;
        int chartLabelFontSize = -1;
        if (!this.isValid(chartLabelFontName)) {
            chartLabelFontName = "Dialog";
        }
        try {
            chartLabelFontStyle = Integer.parseInt(this.properties.getProperty("chartLabelFontStyle"));
            chartLabelFontSize = Integer.parseInt(this.properties.getProperty("chartLabelFontSize"));
        }
        catch (Exception e) {
            chartLabelFontStyle = 0;
            chartLabelFontSize = 12;
        }
        String chartTickLabelFontName = this.properties.getProperty("chartTickLabelFontName");
        int chartTickLabelFontStyle = -1;
        int chartTickLabelFontSize = -1;
        if (!this.isValid(chartTickLabelFontName)) {
            chartTickLabelFontName = "Dialog";
        }
        try {
            chartTickLabelFontStyle = Integer.parseInt(this.properties.getProperty("chartTickLabelFontStyle"));
            chartTickLabelFontSize = Integer.parseInt(this.properties.getProperty("chartTickLabelFontSize"));
        }
        catch (Exception e) {
            chartTickLabelFontStyle = 0;
            chartTickLabelFontSize = 12;
        }
        FontContext.registerFont(fontName, fontStyle, fontSize);
        FontContext.registerChartTitleFont(chartTitleFontName, chartTitleFontStyle, chartTitleFontSize);
        FontContext.registerChartSubTitleFont(chartSubTitleFontName, chartSubTitleFontStyle, chartSubTitleFontSize);
        FontContext.registerChartLabelFont(chartLabelFontName, chartLabelFontStyle, chartLabelFontSize);
        FontContext.registerChartTickLabelFont(chartTickLabelFontName, chartTickLabelFontStyle, chartTickLabelFontSize);
        log.info((Object)("Parameter - fontName : [" + fontName + "]"));
        log.info((Object)("Parameter - fontStyle : [" + fontStyle + "]"));
        log.info((Object)("Parameter - fontSize : [" + fontSize + "]"));
        log.info((Object)("Parameter - chartTitleFontName : [" + chartTitleFontName + "]"));
        log.info((Object)("Parameter - chartTitleFontStyle : [" + chartTitleFontStyle + "]"));
        log.info((Object)("Parameter - chartTitleFontSize : [" + chartTitleFontSize + "]"));
        log.info((Object)("Parameter - chartSubTitleFontName : [" + chartSubTitleFontName + "]"));
        log.info((Object)("Parameter - chartSubTitleFontStyle : [" + chartSubTitleFontStyle + "]"));
        log.info((Object)("Parameter - chartSubTitleFontSize : [" + chartSubTitleFontSize + "]"));
        log.info((Object)("Parameter - chartLabelFontName : [" + chartLabelFontName + "]"));
        log.info((Object)("Parameter - chartLabelFontStyle : [" + chartLabelFontStyle + "]"));
        log.info((Object)("Parameter - chartLabelFontSize : [" + chartLabelFontSize + "]"));
        log.info((Object)("Parameter - chartTickLabelFontName : [" + chartTickLabelFontName + "]"));
        log.info((Object)("Parameter - chartTickLabelFontStyle : [" + chartTickLabelFontStyle + "]"));
        log.info((Object)("Parameter - chartTickLabelFontSize : [" + chartTickLabelFontSize + "]"));
    }

    private void initPDF() {
        String chartPDFSubject;
        String chartPDFAuthor = this.properties.getProperty("chartPDFAuthor");
        if (!this.isValid(chartPDFAuthor)) {
            chartPDFAuthor = "Haojun Ren";
        }
        if (!this.isValid(chartPDFSubject = this.properties.getProperty("chartPDFSubject"))) {
            chartPDFSubject = "Nepxion";
        }
        ChartContext.registerChartPDFAuthor(chartPDFAuthor);
        ChartContext.registerChartPDFSubject(chartPDFSubject);
        log.info((Object)("Parameter - chartPDFAuthor : [" + chartPDFAuthor + "]"));
        log.info((Object)("Parameter - chartPDFSubject : [" + chartPDFSubject + "]"));
    }

    private void initButtonUI() {
        String buttonUI = this.properties.getProperty("buttonUI");
        String buttonStyle = this.properties.getProperty("buttonStyle");
        String customButtonUI = this.properties.getProperty("customButtonUI");
        String customButtonStyle = this.properties.getProperty("customButtonStyle");
        if (this.isValid(buttonUI)) {
            String buttonUIPrefix = ButtonContext.getButtonUIClassPrefix(buttonUI);
            buttonUI = "com.nepxion.swing.style.button." + buttonUIPrefix.toLowerCase() + "." + buttonUIPrefix + "ButtonUI";
            if (this.isValid(buttonStyle)) {
                buttonStyle = "com.nepxion.swing.style.button." + buttonUIPrefix.toLowerCase() + "." + buttonStyle;
            }
        } else if (this.isValid(customButtonUI)) {
            if (this.isValid(buttonStyle)) {
                throw new IllegalArgumentException("It can't be specified ButtonStyle for '" + buttonStyle + "' when using custom ButtonUI");
            }
            if (this.isValid(customButtonStyle)) {
                String buttonUIPrefix = ButtonContext.getButtonUIClassPrefix(customButtonUI);
                customButtonUI = buttonUIPrefix + "ButtonUI";
            }
        }
        if (buttonUI != null) {
            ButtonContext.registerUI(buttonUI, buttonStyle != null ? buttonStyle : customButtonStyle);
        } else if (customButtonUI != null) {
            ButtonContext.registerUI(customButtonUI, buttonStyle != null ? buttonStyle : customButtonStyle);
        }
        log.info((Object)("Parameter - buttonUI : [" + buttonUI + "]"));
        log.info((Object)("Parameter - buttonStyle : [" + buttonStyle + "]"));
        log.info((Object)("Parameter - customButtonUI : [" + customButtonUI + "]"));
        log.info((Object)("Parameter - customButtonStyle : [" + customButtonStyle + "]"));
    }

    private void initPopupMenuTitle() {
        String popupMenuTitle = this.properties.getProperty("popupMenuTitle");
        if (!this.isValid(popupMenuTitle)) {
            popupMenuTitle = "Nepxion";
        }
        PopupMenuContext.registerTitle(popupMenuTitle);
        log.info((Object)("Parameter - popupMenuTitle : [" + popupMenuTitle + "]"));
    }

    private void initIconPath() {
        String iconPath = this.properties.getProperty("iconPath");
        if (!this.isValid(iconPath)) {
            iconPath = "com/nepxion/swing/icon/image/";
        }
        IconContext.registerIconFolder(iconPath);
        log.info((Object)("Parameter - iconPath : [" + iconPath + "]"));
    }

    private void initTopicComponent() {
        String topicComponent = this.properties.getProperty("topicComponent");
        TopicContext.registerTopicComponent(topicComponent);
        log.info((Object)("Parameter - topicComponent : [" + topicComponent + "]"));
    }

    private void initLookAndFeel() {
        String lookAndFeel = this.properties.getProperty("lookAndFeel");
        String customLookAndFeel = this.properties.getProperty("customLookAndFeel");
        if (!this.isValid(lookAndFeel) && !this.isValid(customLookAndFeel)) {
            lookAndFeel = "PlasticXPLookAndFeel";
        }
        if (this.isValid(lookAndFeel)) {
            LookAndFeelManager.invokeLookAndFeel(lookAndFeel);
        } else if (this.isValid(customLookAndFeel)) {
            LookAndFeelManager.setLookAndFeel(customLookAndFeel);
        }
        log.info((Object)("Parameter - lookAndFeel : [" + lookAndFeel + "]"));
        log.info((Object)("Parameter - customLookAndFeel : [" + customLookAndFeel + "]"));
    }

    public boolean isValid(String content) {
        return content != null && !content.trim().equals("");
    }
}

