/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.gradient.JBackgroundPainter;
import com.nepxion.swing.shrinkbar.ShrinkContants;
import com.nepxion.swing.shrinkbar.ShrinkListener;
import com.nepxion.swing.shrinkbar.SplitListener;
import com.nepxion.swing.style.texture.shrink.IHeaderTextureStyle;
import com.nepxion.swing.toolbar.JBasicToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JShrinkHeader
extends JPanel
implements ShrinkContants {
    private int placement = 1;
    private int contentPaneType = 2;
    private JLabel resizeHandlerLabel;
    private JLabel shrinkHandlerLabel;
    private JLabel label;
    private JBasicToolBar toolBar;
    private int shrinkedWidth = 40;
    private int preferredWidth = 0;
    private IHeaderTextureStyle headerTextureStyle;
    private boolean shrinked = false;
    private boolean shrinkable = true;

    public JShrinkHeader(int placement) {
        this(placement, 2);
    }

    public JShrinkHeader(int placement, IHeaderTextureStyle headerTextureStyle) {
        this(placement, 2, headerTextureStyle);
    }

    public JShrinkHeader(int placement, int contentPaneType) {
        this(placement, contentPaneType, DEFAULT_HEADER_TEXTURE_STYLE);
    }

    public JShrinkHeader(int placement, int contentPaneType, IHeaderTextureStyle headerTextureStyle) {
        this.placement = placement;
        this.contentPaneType = contentPaneType;
        this.headerTextureStyle = headerTextureStyle;
        this.initComponents();
    }

    private void initComponents() {
        SplitListener splitListener = new SplitListener(this);
        ShrinkListener shrinkListener = new ShrinkListener(this);
        this.resizeHandlerLabel = new JLabel(this.headerTextureStyle.getResizeHandlerImageIcon());
        this.resizeHandlerLabel.addMouseListener(splitListener);
        this.resizeHandlerLabel.addMouseMotionListener(splitListener);
        this.resizeHandlerLabel.setBorder(BorderFactory.createEmptyBorder(2, 7, 2, 7));
        this.shrinkHandlerLabel = new JLabel();
        this.shrinkHandlerLabel.addMouseListener(shrinkListener);
        this.shrinkHandlerLabel.setBorder(BorderFactory.createEmptyBorder(2, 7, 2, 7));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.togglePlacement();
        this.toggleContentPaneType();
        this.updateShrinkIcon();
        this.updateCursor();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JBasicToolBar getToolBar() {
        return this.toolBar;
    }

    public IHeaderTextureStyle getHeaderTextureStyle() {
        return this.headerTextureStyle;
    }

    public String getTitle() {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.label.getText();
    }

    public void setTitle(String title) {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.label.setText(title);
    }

    public Icon getIcon() {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.label.getIcon();
    }

    public void setIcon(Icon icon) {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.label.setIcon(icon);
    }

    @Override
    public String getToolTipText() {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.label.getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.label.setToolTipText(toolTipText);
    }

    public Color getTitleColor() {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.label.getForeground();
    }

    public void setTitleColor(Color color) {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.label.setForeground(color);
    }

    public Font getTitleFont() {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.label.getFont();
    }

    public void setTitleFont(Font font) {
        if (this.label == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.label.setFont(font);
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setPlacement(int placement) {
        this.placement = placement;
        this.togglePlacement();
    }

    protected void togglePlacement() {
        if (!this.shrinkable) {
            throw new IllegalArgumentException("The shrinking is disabled");
        }
        if (this.placement == 0) {
            this.add((Component)this.shrinkHandlerLabel, "East");
            this.add((Component)this.resizeHandlerLabel, "West");
        } else if (this.placement == 1) {
            this.add((Component)this.resizeHandlerLabel, "East");
            this.add((Component)this.shrinkHandlerLabel, "West");
        }
    }

    public int getContentPaneType() {
        return this.contentPaneType;
    }

    public void setContentPaneType(int contentPaneType) {
        this.contentPaneType = contentPaneType;
        this.toggleContentPaneType();
    }

    protected void toggleContentPaneType() {
        if (this.contentPaneType == 2) {
            if (this.label == null) {
                this.label = new JLabel();
                this.label.setForeground(this.headerTextureStyle.getForeground());
                this.label.setBorder(BorderFactory.createEmptyBorder());
            }
            this.add((Component)this.label, "Center");
        } else if (this.contentPaneType == 3) {
            if (this.toolBar == null) {
                this.toolBar = new JBasicToolBar();
                this.toolBar.setOpaque(false);
                this.toolBar.setBorder(BorderFactory.createEmptyBorder());
            }
            this.add((Component)this.toolBar, "Center");
        }
    }

    public boolean isShrinked() {
        return this.shrinked;
    }

    public void setShrinked(boolean shrinked) {
        if (!this.shrinkable) {
            throw new IllegalArgumentException("The shrinking is disabled");
        }
        if (this.shrinked == shrinked) {
            return;
        }
        Container parent = this.getParent();
        Dimension size = parent.getPreferredSize();
        if (shrinked) {
            this.preferredWidth = size.width;
            size = new Dimension(this.shrinkedWidth, size.height);
        } else {
            int width = this.preferredWidth;
            int height = parent.getPreferredSize().height;
            size = new Dimension(width, height);
        }
        parent.setPreferredSize(size);
        this.shrinked = shrinked;
        this.resizeHandlerLabel.setVisible(!shrinked);
        if (this.label != null) {
            this.label.setVisible(!shrinked);
        }
        if (this.toolBar != null) {
            this.toolBar.setVisible(!shrinked);
        }
        this.revalidateParent();
        this.updateShrinkIcon();
        this.updateCursor();
    }

    protected void toggleShrinked() {
        boolean shrinked = this.isShrinked();
        this.setShrinked(!shrinked);
    }

    public boolean isShrinkable() {
        return this.shrinkable;
    }

    public void setShrinkable(boolean shrinkable) {
        this.shrinkable = shrinkable;
        if (shrinkable) {
            this.togglePlacement();
            if (this.label != null) {
                this.label.setBorder(BorderFactory.createEmptyBorder());
            }
            if (this.toolBar != null) {
                this.toolBar.setBorder(BorderFactory.createEmptyBorder());
            }
        } else {
            if (this.retrieveComponent(this.resizeHandlerLabel)) {
                this.remove(this.resizeHandlerLabel);
            }
            if (this.retrieveComponent(this.shrinkHandlerLabel)) {
                this.remove(this.shrinkHandlerLabel);
            }
            if (this.label != null) {
                this.label.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            }
            if (this.toolBar != null) {
                this.toolBar.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            }
        }
    }

    private boolean retrieveComponent(Component component) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (c != component) continue;
            return true;
        }
        return false;
    }

    public int getShrinkedWidth() {
        return this.shrinkedWidth;
    }

    public void setShrinkedWidth(int shrinkedWidth) {
        this.shrinkedWidth = shrinkedWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.headerTextureStyle.getHeight();
        return new Dimension(super.getPreferredSize().width, height);
    }

    protected void revalidateParent() {
        Container container = this.getParent();
        if (container instanceof JComponent) {
            JComponent component = (JComponent)container;
            component.revalidate();
        }
    }

    protected void updateShrinkIcon() {
        ImageIcon shrinkIcon = null;
        if (this.shrinked) {
            if (this.placement == 0) {
                shrinkIcon = this.headerTextureStyle.getShrinkHandlerLeftImageIcon();
            } else if (this.placement == 1) {
                shrinkIcon = this.headerTextureStyle.getShrinkHandlerRightImageIcon();
            }
        } else if (this.placement == 0) {
            shrinkIcon = this.headerTextureStyle.getShrinkHandlerRightImageIcon();
        } else if (this.placement == 1) {
            shrinkIcon = this.headerTextureStyle.getShrinkHandlerLeftImageIcon();
        }
        this.shrinkHandlerLabel.setIcon(shrinkIcon);
    }

    protected void updateCursor() {
        if (this.shrinked) {
            this.resizeHandlerLabel.setCursor(Cursor.getDefaultCursor());
        } else {
            this.resizeHandlerLabel.setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        JBackgroundPainter.paintBackground((Component)this, g, this.headerTextureStyle);
    }
}

