/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.fullscreen;

import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.KeyStroke;

public class FullScreenSupport {
    private JWindow fullScreenWindow;
    private Container container;
    private Component fullScreenComponent;
    private Object layoutConstraints;

    public FullScreenSupport(Component fullScreenComponent) {
        this(fullScreenComponent, null, null);
    }

    public FullScreenSupport(Component fullScreenComponent, Object layoutConstraints) {
        this(fullScreenComponent, layoutConstraints, null);
    }

    public FullScreenSupport(Component fullScreenComponent, KeyStroke toggleFullScreenKeyStroke) {
        this(fullScreenComponent, null, toggleFullScreenKeyStroke);
    }

    public FullScreenSupport(Component fullScreenComponent, Object layoutConstraints, KeyStroke toggleFullScreenKeyStroke) {
        this.fullScreenComponent = fullScreenComponent;
        this.layoutConstraints = layoutConstraints;
        if (fullScreenComponent instanceof JComponent) {
            JComponent component = (JComponent)fullScreenComponent;
            if (toggleFullScreenKeyStroke != null) {
                ActionListener toggleFullScreenActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FullScreenSupport.this.toggleFullScreen();
                    }
                };
                KeyStrokeManager.registerComponent(component, toggleFullScreenActionListener, toggleFullScreenKeyStroke);
            }
            ActionListener exitFullScreenActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FullScreenSupport.this.exitFullScreen();
                }
            };
            KeyStrokeManager.registerComponentToEscapeKey(component, exitFullScreenActionListener);
        }
    }

    public void toggleFullScreen() {
        if (this.isFullScreen()) {
            this.exitFullScreen();
        } else {
            this.showFullScreen();
        }
    }

    public void showFullScreen() {
        if (this.fullScreenWindow != null || this.fullScreenComponent == null) {
            return;
        }
        Window parentWindow = HandleManager.getWindow(this.fullScreenComponent);
        this.fullScreenWindow = parentWindow == null ? new JWindow() : new JWindow(parentWindow, parentWindow.getGraphicsConfiguration());
        this.container = this.fullScreenComponent.getParent();
        if (this.container != null) {
            this.container.remove(this.fullScreenComponent);
            if (this.container instanceof JComponent) {
                ((JComponent)this.container).revalidate();
            } else {
                this.container.invalidate();
            }
        }
        this.fullScreenWindow.getContentPane().setLayout(new BorderLayout());
        this.fullScreenWindow.getContentPane().add(this.fullScreenComponent, "Center");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        GraphicsConfiguration graphicsconfiguration = this.fullScreenWindow.getGraphicsConfiguration();
        Insets insets = toolkit.getScreenInsets(graphicsconfiguration);
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        this.fullScreenWindow.setSize(dimension);
        this.fullScreenWindow.setLocation(insets.left, insets.top);
        this.fullScreenWindow.setVisible(true);
        this.fullScreenWindow.validate();
        this.fullScreenComponent.requestFocus();
    }

    public void exitFullScreen() {
        if (this.fullScreenWindow == null) {
            return;
        }
        this.fullScreenWindow.getContentPane().removeAll();
        this.fullScreenWindow.setVisible(false);
        this.fullScreenWindow.dispose();
        this.fullScreenWindow = null;
        if (this.container != null) {
            if (this.layoutConstraints == null) {
                this.container.add(this.fullScreenComponent);
            } else {
                this.container.add(this.fullScreenComponent, this.layoutConstraints);
            }
            if (this.container instanceof JComponent) {
                ((JComponent)this.container).revalidate();
            } else {
                this.container.invalidate();
            }
        }
        this.fullScreenComponent.requestFocus();
    }

    public boolean isFullScreen() {
        return this.fullScreenWindow != null;
    }
}

