/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.bar;

import com.nepxion.swing.chart.JChartFactory;
import com.nepxion.swing.chart.JChartPanel;
import com.nepxion.swing.chart.bar.IBarRenderer;
import com.nepxion.swing.chart.bar.RectangleBarRenderer;
import com.nepxion.swing.chart.bar.RectangleBarRenderer3D;
import com.nepxion.swing.chart.bar.StackedRectangleBarRenderer;
import com.nepxion.swing.chart.bar.StackedRectangleBarRenderer3D;
import com.nepxion.swing.font.FontContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategorySeriesLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.TextAnchor;
import org.jfree.util.SortOrder;

public class RectangleBarChartFactory {
    public static CategoryPlot createCategoryPlot(CategoryDataset categoryDataset, PlotOrientation orientation, String categoryAxisLabel, String valueAxisLabel, String toolTipText, String legendToolTipText, boolean isStacked, boolean isCategoryLabelRotated) {
        CategoryPlot categoryPlot = RectangleBarChartFactory.createCategoryPlot(categoryDataset, orientation, categoryAxisLabel, valueAxisLabel, isStacked, true, true, false);
        RectangleBarChartFactory.setCategoryPlotPreference(categoryPlot, orientation, toolTipText, legendToolTipText, isCategoryLabelRotated, 1.0f);
        return categoryPlot;
    }

    public static CategoryPlot createCategoryPlot(CategoryDataset categoryDataset, PlotOrientation orientation, String categoryAxisLabel, String valueAxisLabel, boolean stacked, boolean labels, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        IBarRenderer barRenderer = null;
        barRenderer = stacked ? new StackedRectangleBarRenderer() : new RectangleBarRenderer();
        if (stacked) {
            barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
            barRenderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT));
            barRenderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT));
        } else if (orientation == PlotOrientation.VERTICAL) {
            barRenderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER));
            barRenderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER));
        }
        if (labels) {
            barRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        }
        if (tooltips) {
            barRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            barRenderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)barRenderer);
        categoryPlot.setOrientation(orientation);
        return categoryPlot;
    }

    public static CategoryPlot createCategoryPlot3D(CategoryDataset categoryDataset, PlotOrientation orientation, String categoryAxisLabel, String valueAxisLabel, String toolTipText, String legendToolTipText, boolean isStacked, boolean isCategoryLabelRotated) {
        CategoryPlot categoryPlot = RectangleBarChartFactory.createCategoryPlot3D(categoryDataset, orientation, categoryAxisLabel, valueAxisLabel, isStacked, true, true, false);
        RectangleBarChartFactory.setCategoryPlotPreference(categoryPlot, orientation, toolTipText, legendToolTipText, isCategoryLabelRotated, 0.75f);
        return categoryPlot;
    }

    public static CategoryPlot createCategoryPlot3D(CategoryDataset categoryDataset, PlotOrientation orientation, String categoryAxisLabel, String valueAxisLabel, boolean isStacked, boolean labels, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis3D categoryAxis = new CategoryAxis3D(categoryAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel);
        IBarRenderer barRenderer3D = null;
        barRenderer3D = isStacked ? new StackedRectangleBarRenderer3D() : new RectangleBarRenderer3D();
        if (isStacked) {
            barRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
            barRenderer3D.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            barRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.BOTTOM_LEFT));
            barRenderer3D.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_LEFT));
            barRenderer3D.setItemLabelAnchorOffset(20.0);
        } else if (orientation == PlotOrientation.VERTICAL) {
            barRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT));
            barRenderer3D.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.BASELINE_CENTER));
            barRenderer3D.setItemLabelAnchorOffset(12.0);
        }
        if (labels) {
            barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        }
        if (tooltips) {
            barRenderer3D.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            barRenderer3D.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)barRenderer3D);
        categoryPlot.setOrientation(orientation);
        return categoryPlot;
    }

    public static void setCategoryPlotPreference(CategoryPlot categoryPlot, PlotOrientation orientation, String toolTipText, String legendToolTipText, boolean isCategoryLabelRotated, float foregroundAlpha) {
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setBaseItemLabelsVisible(true);
        barRenderer.setMaximumBarWidth(0.05);
        barRenderer.setDrawBarOutline(true);
        barRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("{1} : " + toolTipText + " [{2}]", NumberFormat.getNumberInstance()));
        barRenderer.setLegendItemToolTipGenerator((CategorySeriesLabelGenerator)new StandardCategorySeriesLabelGenerator(legendToolTipText + " - {0}"));
        categoryPlot.setRowRenderingOrder(SortOrder.DESCENDING);
        categoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        if (isCategoryLabelRotated) {
            categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)Math.toRadians(30.0)));
        }
        categoryPlot.getDomainAxis().setUpperMargin(0.03);
        categoryPlot.getDomainAxis().setLowerMargin(0.03);
        categoryPlot.getRangeAxis().setUpperMargin(0.1);
        categoryPlot.setForegroundAlpha(foregroundAlpha);
        categoryPlot.setRangePannable(true);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setBackgroundPaint((Paint)new Color(128, 128, 128, 30));
    }

    public static Paint getSectionPaint(CategoryPlot categoryPlot, int index) {
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        return barRenderer.getSeriesPaint(index);
    }

    public static void setSectionPaint(CategoryPlot categoryPlot, boolean is3D) {
        for (int i = 0; i < categoryPlot.getDataset().getRowCount(); ++i) {
            RectangleBarChartFactory.setSectionPaint(categoryPlot, is3D, i, i);
        }
    }

    public static void setSectionPaint(CategoryPlot categoryPlot, boolean is3D, int seriesIndex, int colorIndex) {
        Paint paint = null;
        paint = is3D ? JChartFactory.getPaint(colorIndex) : JChartFactory.getGradientPaint(colorIndex);
        RectangleBarChartFactory.setSectionPaint(categoryPlot, seriesIndex, paint);
    }

    public static void setSectionPaint(CategoryPlot categoryPlot, int index, Paint paint) {
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setSeriesPaint(index, paint);
    }

    public static void setSectionPaint(CategoryPlot categoryPlot, int index, Color color1, Color color2) {
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setSeriesPaint(index, (Paint)new GradientPaint(0.0f, 0.0f, color1, 0.0f, 0.0f, color2));
    }

    public static void setValueMarker(CategoryPlot categoryPlot, Comparable category, String text, double value) {
        RectangleBarChartFactory.setValueMarker(categoryPlot, category, text, value, new Color(221, 221, 221));
    }

    public static void setValueMarker(CategoryPlot categoryPlot, Comparable category, String text, double value, Paint paint) {
        RectangleBarChartFactory.setValueMarker(categoryPlot, category, text, value, paint, Color.gray);
    }

    public static void setValueMarker(CategoryPlot categoryPlot, Comparable category, String text, double value, Paint paint, Paint outlinePaint) {
        ValueMarker valueMarker = new ValueMarker(value, paint, (Stroke)new BasicStroke(1.0f), outlinePaint, (Stroke)new BasicStroke(1.0f), 0.75f);
        categoryPlot.addRangeMarker((Marker)valueMarker, Layer.BACKGROUND);
        CategoryTextAnnotation categoryTextAnnotation = new CategoryTextAnnotation(text, category, value + 0.01);
        categoryTextAnnotation.setCategoryAnchor(CategoryAnchor.START);
        categoryTextAnnotation.setFont(FontContext.getChartLabelFont());
        categoryTextAnnotation.setTextAnchor(TextAnchor.BOTTOM_LEFT);
        categoryPlot.addAnnotation((CategoryAnnotation)categoryTextAnnotation);
    }

    public static int[] getCategoryPlotSelectionIndexes(JChartPanel chartPanel) {
        JFreeChart chart = chartPanel.getChart();
        return RectangleBarChartFactory.getCategoryPlotSelectionIndexes(chart);
    }

    public static int[] getCategoryPlotSelectionIndexes(JFreeChart chart) {
        CategoryItemRenderer itemRenderer = chart.getCategoryPlot().getRenderer();
        if (itemRenderer instanceof IBarRenderer) {
            IBarRenderer chartRenderer = (IBarRenderer)itemRenderer;
            int selectionRow = chartRenderer.getSelectionRow();
            int selectionColumn = chartRenderer.getSelectionColumn();
            return new int[]{selectionRow, selectionColumn};
        }
        return null;
    }
}

