/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.ImageIcon;
import twaver.Group;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.D.M;
import twaver.base.A.D.P;
import twaver.base.A.E.W;
import twaver.base.A.E.b;
import twaver.base.A.E.g;
import twaver.base.A.E.j;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.NodeSVGUI;

public class GroupSVGUI
extends NodeSVGUI {
    private static final String X = "Group";
    private Group Y = null;

    public GroupSVGUI(TSVGNetwork network, Group group) {
        super(network, group);
        this.Y = group;
    }

    public Point getHotspot(SVGContext context) {
        if (!this.Y.isExpand() && this.Y.isCustomDraw()) {
            return super.getHotspot(context);
        }
        Shape shape = context.getGroupShape(this.Y);
        return j.A(shape, this.Y);
    }

    protected Shape createShape(SVGContext context) {
        int groupType = this.Y.getGroupType();
        if (groupType == 1) {
            return g.D(this.Y, this.network, context);
        }
        if (groupType == 4) {
            return g.A(this.Y, this.network, context);
        }
        if (groupType == 5) {
            return g.G(this.Y, this.network, context);
        }
        if (groupType == 2) {
            if (this.Y.isGroup3D()) {
                return g.F(this.Y, this.network, context);
            }
            return g.B(this.Y, this.network, context);
        }
        if (groupType == 3) {
            if (this.Y.isGroup3D()) {
                return g.H(this.Y, this.network, context);
            }
            return g.C(this.Y, this.network, context);
        }
        if (groupType == 6) {
            return g.I(this.Y, this.network, context);
        }
        return null;
    }

    protected void prepareElementSVGHeader(SVGContext context, StringBuffer head) {
        super.prepareElementSVGHeader(context, head);
        I.B(head, X);
        if (this.Y.isGroupDoubleClickEnable()) {
            head.append(" group-expand='" + this.Y.isExpand() + "'");
        }
    }

    protected SVGStruct toBodySVG(SVGContext context) {
        Stroke stroke;
        float alpha;
        Color outlineObject;
        if (!W.C(this.element)) {
            return super.toBodySVG(context);
        }
        Shape shape = this.createShape(context);
        if (shape == null) {
            return SVGStruct.EMPTY;
        }
        context.registerGroupShape(this.Y, shape);
        Object fillObject = null;
        Color drarkerObject = null;
        if (this.Y.isGroupFill()) {
            Color fillColor = this.Y.getGroupFillColor();
            fillColor = this.getPaintBodyColor(fillColor);
            fillObject = this.Y.isGroupGradient() ? this.getGradientID(context, this.Y.getGroupGradientFactory(), this.Y.getGroupGradientColor(), fillColor) : this.getFillObject(context, fillColor);
            drarkerObject = fillColor.darker();
        }
        if ((outlineObject = super.getStateOutlineColor()) == null && this.Y.isGroupOutline()) {
            outlineObject = this.Y.getGroupOutlineColor();
        }
        if ((alpha = this.getRenderAlpha()) == 1.0f && !this.Y.isGroupOpaque()) {
            alpha = 0.5f;
        }
        if (!((stroke = b.F(this.element, "group.outline.stroke")) instanceof BasicStroke)) {
            stroke = TWaverConst.DOUBLE_WIDTH_STROKE;
        }
        StringBuffer sb = new StringBuffer();
        if (shape instanceof M) {
            M ellipse = (M)shape;
            I.A(context, sb, ellipse.A(), fillObject, (Object)outlineObject, (Object)stroke, alpha, 0.0, null);
            I.A(context, sb, ellipse.B(), (Object)drarkerObject, (Object)outlineObject, (Object)stroke, alpha, 0.0, null);
        } else if (shape instanceof P) {
            P parallelogram = (P)shape;
            I.A(context, sb, parallelogram, fillObject, (Object)outlineObject, (Object)stroke, alpha, 0.0, null);
            I.A(context, sb, parallelogram.E(), (Object)drarkerObject, (Object)outlineObject, (Object)stroke, alpha, 0.0, null);
            I.A(context, sb, parallelogram.F(), (Object)drarkerObject, (Object)outlineObject, (Object)stroke, alpha, 0.0, null);
        } else {
            I.A(context, sb, shape, fillObject, (Object)outlineObject, (Object)stroke, alpha, 0.0, null);
        }
        return new SVGStruct(sb.toString(), shape.getBounds());
    }

    protected SVGStruct toAttachmentSVG(SVGContext context) {
        SVGStruct struct = super.toAttachmentSVG(context);
        if (this.Y.isGroupHandlerVisible()) {
            StringBuffer sb = new StringBuffer(struct.getSvg() == null ? "" : struct.getSvg());
            String imageURL = null;
            imageURL = this.Y.isEmpty() ? this.Y.getGroupHandlerEmptyIcon() : (this.Y.isExpand() ? this.Y.getGroupHandlerExpandIcon() : this.Y.getGroupHandlerCloseIcon());
            ImageIcon icon = TWaverUtil.getImageIcon(imageURL);
            Dimension size = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            Point location = I.A(this.network, context, this.Y, size, this.Y.getGroupHandlerPosition(), this.Y.getGroupHandlerXOffset(), this.Y.getGroupHandlerYOffset());
            I.A(context, sb, " type = 'handler' group-expand='" + this.Y.isExpand() + "'", imageURL, null, location.x, location.y, 1.0f);
            struct.setSvg(sb.toString());
        }
        return struct;
    }
}

