/*
 * Decompiled with CFR 0.152.
 */
package y.layout.planar;

import java.util.Comparator;
import y.algo.GraphConnectivity;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.planar.InitialPlanarSubgraph;
import y.layout.planar.PlanarInformation;
import y.util.D;

public class BCCSubgraph
implements InitialPlanarSubgraph {
    private InitialPlanarSubgraph u = null;
    private PlanarInformation t;
    private Graph s;
    private EdgeList r;
    private boolean v;

    public BCCSubgraph(InitialPlanarSubgraph initialPlanarSubgraph) {
        this.u = initialPlanarSubgraph;
        this.r = new EdgeList();
        this.v = false;
    }

    public void createPlanarization(PlanarInformation planarInformation) {
        YCursor yCursor;
        EdgeCursor edgeCursor;
        EdgeList edgeList = null;
        EdgeList edgeList2 = null;
        EdgeList[] edgeListArray = null;
        NodeList nodeList = new NodeList();
        this.t = planarInformation;
        this.s = planarInformation.getGraph();
        NodeMap nodeMap = this.s.createNodeMap();
        edgeListArray = GraphConnectivity.biconnectedComponents(planarInformation.getGraph());
        edgeList = this.a(this.s);
        int n = 0;
        while (n < edgeListArray.length) {
            Object object;
            edgeList2 = edgeListArray[n];
            edgeCursor = edgeList2.edges();
            while (edgeCursor.ok()) {
                this.s.unhide(edgeCursor.edge());
                edgeCursor.next();
            }
            nodeList.clear();
            yCursor = this.s.nodes();
            while (yCursor.ok()) {
                object = yCursor.node();
                if (((Node)object).degree() == 0) {
                    nodeList.add(object);
                    this.s.hide(yCursor.node());
                }
                yCursor.next();
            }
            D.bug(this, 0, "Compute Planar Subgraph for biconnected component...");
            this.u.createPlanarization(this.t);
            D.bug(this, 0, "Save planarization...");
            this.b(nodeMap);
            D.bug(this, 0, "Store hidden edges...");
            object = this.u.getHiddenEdges().edges();
            while (object.ok()) {
                this.r.add(object.edge());
                object.next();
            }
            NodeCursor nodeCursor = nodeList.nodes();
            while (nodeCursor.ok()) {
                this.s.unhide(nodeCursor.node());
                nodeCursor.next();
            }
            EdgeCursor edgeCursor2 = this.s.edges();
            while (edgeCursor2.ok()) {
                if (this.t.isInsertedEdge(edgeCursor2.edge())) {
                    edgeList.add(edgeCursor2.edge());
                }
                this.s.hide(edgeCursor2.edge());
                edgeCursor2.next();
            }
            ++n;
        }
        edgeCursor = edgeList.edges();
        while (edgeCursor.ok()) {
            this.s.unhide(edgeCursor.edge());
            edgeCursor.next();
        }
        yCursor = this.r.edges();
        while (yCursor.ok()) {
            this.s.hide(yCursor.edge());
            yCursor.next();
        }
        this.a(nodeMap);
        this.t.calcFaces();
        this.s.disposeNodeMap(nodeMap);
        this.v = true;
        this.dispose();
    }

    public EdgeList getHiddenEdges() {
        if (this.v) {
            return this.r;
        }
        throw new RuntimeException("Invalid Execution Order: call 'createPlanarization' first!");
    }

    private void b(NodeMap nodeMap) {
        NodeCursor nodeCursor = this.s.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            EdgeList edgeList = (EdgeList)nodeMap.get(node);
            if (edgeList == null) {
                edgeList = new EdgeList();
                nodeMap.set(node, edgeList);
            }
            EdgeCursor edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                edgeList.add(edgeCursor.edge());
                edgeCursor.next();
            }
            nodeCursor.next();
        }
    }

    private void a(NodeMap nodeMap) {
        NodeCursor nodeCursor = this.s.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            final EdgeList edgeList = (EdgeList)nodeMap.get(node);
            node.sortOutEdges(new Comparator(){

                public int compare(Object object, Object object2) {
                    Edge edge = (Edge)object;
                    Edge edge2 = (Edge)object2;
                    return edgeList.indexOf(edge) - edgeList.indexOf(edge2);
                }
            });
            nodeCursor.next();
        }
    }

    private EdgeList a(Graph graph) {
        EdgeList edgeList = new EdgeList();
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            edgeList.add(edge);
            graph.hide(edge);
            edgeCursor.next();
        }
        return edgeList;
    }

    public void dispose() {
    }
}

