/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon;

import com.nepxion.swing.framework.ribbon.JRibbon;
import com.nepxion.swing.framework.ribbon.JRibbonContainer;
import com.nepxion.swing.gradient.JGradientPainter;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.scrollpane.JAutoRollScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class JRibbonBar
extends JAutoRollScrollPane
implements SwingConstants {
    private JRibbonContainer ribbonContainer;
    private JPanel ribbonView;

    public JRibbonBar(JRibbonContainer ribbonContainer) {
        this.ribbonContainer = ribbonContainer;
        this.ribbonView = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                JGradientPainter.fastFill(g2d, new Rectangle(0, 0, width, 1), new Color(231, 239, 248), new Color(231, 239, 248), true);
                JGradientPainter.fastFill(g2d, new Rectangle(0, 1, width, 16), new Color(222, 235, 247), new Color(210, 224, 241), true);
                JGradientPainter.fastFill(g2d, new Rectangle(0, 17, width, height - 18), new Color(199, 216, 237), new Color(231, 242, 255), true);
            }
        };
        this.ribbonView.setLayout(new FiledLayout(1, 2, 2));
        this.ribbonView.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setViewportView(this.ribbonView);
    }

    public List getRibbons() {
        ArrayList<Component> ribbons = new ArrayList<Component>();
        for (int i = 0; i < this.ribbonView.getComponentCount(); ++i) {
            Component component = this.ribbonView.getComponent(i);
            if (!(component instanceof JRibbon)) continue;
            ribbons.add(component);
        }
        return ribbons;
    }

    public JRibbonContainer getRibbonContainer() {
        return this.ribbonContainer;
    }

    public JPanel getRibbonView() {
        return this.ribbonView;
    }

    public void toggleFacade(String showType, int showValue) {
        List ribbons = this.getRibbons();
        for (JRibbon ribbon : ribbons) {
            ribbon.toggleFacade(showType, showValue);
        }
    }
}

