/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.table;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.renderer.table.DefaultTableCellRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;

public class ElementTableCellRenderer
extends DefaultTableCellRenderer {
    private Icon cellIcon;
    private int cellHeight = -1;

    public ElementTableCellRenderer() {
        this((Icon)null);
    }

    public ElementTableCellRenderer(int cellHeight) {
        this((Icon)null, cellHeight);
    }

    public ElementTableCellRenderer(Icon cellIcon) {
        this(cellIcon, -1);
    }

    public ElementTableCellRenderer(Icon cellIcon, int cellHeight) {
        this.cellIcon = cellIcon;
        this.cellHeight = cellHeight;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.cellHeight > 0 && table.getRowHeight() != this.cellHeight) {
            table.setRowHeight(this.cellHeight);
        }
        if (value instanceof IElementNode) {
            IElementNode elementNode = (IElementNode)value;
            this.setText(elementNode.getText());
            this.setIcon(elementNode.getIcon());
            this.setToolTipText(elementNode.getToolTipText());
        } else if (value instanceof Icon) {
            this.setText("");
            this.setIcon((Icon)value);
        } else {
            this.setText("");
            if (this.cellIcon != null) {
                this.setIcon(this.cellIcon);
            }
        }
        return this;
    }
}

