/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.layout.organic.OrganicLayouter;
import y.module.LayoutModule;
import y.option.OptionHandler;
import y.view.Selections;

public class OrganicLayoutModule
extends LayoutModule {
    private static final String e9 = "ACTIVATE_DETERMINISTIC_MODE";
    private static final String fl = "ACTIVATE_TREE_BEAUTIFIER";
    private static final String fp = "MODE";
    private static final String fg = "MAXIMAL_DURATION";
    private static final String fn = "ITERATION_FACTOR";
    private static final String fb = "OBEY_NODE_SIZES";
    private static final String fr = "GRAVITY_FACTOR";
    private static final String e3 = "SPHERE_OF_ACTION";
    private static final String e6 = "INITIAL_PLACEMENT";
    private static final String fi = "PREFERRED_EDGE_LENGTH";
    private static final String fc = "VISUAL";
    private static final String ff = "ALGORITHM";
    private static final String fq = "ORGANIC";
    private static final String fj = "ONLY_SELECTION";
    private static final String e8 = "MAINLY_SELECTION";
    private static final String e7 = "ALL";
    private static final String e5 = "AS_IS";
    private static final String fh = "RANDOM";
    private static final String e4 = "AT_ORIGIN";
    private static final String fo = "EDGE_LENGTH_DEVIATION";
    private static final String fe = "REPULSION";
    private static final String fd = "ATTRACTION";
    private static final String[] fm = new String[]{"RANDOM", "AT_ORIGIN", "AS_IS"};
    private static final String[] fk = new String[]{"ALL", "MAINLY_SELECTION", "ONLY_SELECTION"};
    private OrganicLayouter fa;

    public OrganicLayoutModule() {
        super(fq, "yWorks Graph Layout Team", "Wrapper for OrganicLayouter");
    }

    protected OptionHandler createOptionHandler() {
        this.c();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.useSection(fc);
        optionHandler.addEnum(e3, fk, this.fa.getSphereOfAction());
        optionHandler.addEnum(e6, fm, this.fa.getInitialPlacement());
        optionHandler.addInt(fi, this.fa.getPreferredEdgeLength(), 0, 500);
        optionHandler.addBool(fb, this.fa.getObeyNodeSize());
        optionHandler.addInt(fd, this.fa.getAttraction(), 0, 2);
        optionHandler.addInt(fe, this.fa.getRepulsion(), 0, 2);
        optionHandler.addDouble(fr, this.fa.getGravityFactor(), -0.2, 2.0, 1);
        optionHandler.addBool(fl, this.fa.getActivateTreeBeautifier());
        optionHandler.useSection(ff);
        optionHandler.addDouble(fn, this.fa.getIterationFactor());
        optionHandler.addInt(fg, (int)(this.fa.getMaximumDuration() / 1000L));
        optionHandler.addBool(e9, this.fa.getActivateDeterministicMode());
        return optionHandler;
    }

    protected void init() {
        this.c();
        OptionHandler optionHandler = this.getOptionHandler();
        this.fa.setPreferredEdgeLength(optionHandler.getInt(fc, fi));
        this.fa.setMaximumDuration(1000 * optionHandler.getInt(ff, fg));
        this.fa.setInitialPlacement(OptionHandler.getIndex(fm, optionHandler.getString(fc, e6)));
        this.fa.setSphereOfAction(OptionHandler.getIndex(fk, optionHandler.getString(fc, e3)));
        this.fa.setGravityFactor(optionHandler.getDouble(fc, fr));
        this.fa.setObeyNodeSize(optionHandler.getBool(fc, fb));
        this.fa.setIterationFactor(optionHandler.getDouble(ff, fn));
        this.fa.setActivateTreeBeautifier(optionHandler.getBool(fc, fl));
        this.fa.setActivateDeterministicMode(optionHandler.getBool(ff, e9));
        this.fa.setAttraction(optionHandler.getInt(fc, fd));
        this.fa.setRepulsion(2 - optionHandler.getInt(fc, fe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainrun() {
        this.c();
        try {
            this.getGraph2D().addDataProvider(OrganicLayouter.SPHERE_OF_ACTION_NODES, Selections.createSelectionNodeMap(this.getGraph2D()));
            this.launchLayouter(this.fa);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getGraph2D().removeDataProvider(OrganicLayouter.SPHERE_OF_ACTION_NODES);
            throw throwable;
        }
        this.getGraph2D().removeDataProvider(OrganicLayouter.SPHERE_OF_ACTION_NODES);
    }

    protected void dispose() {
        this.fa = null;
    }

    private void c() {
        if (this.fa == null) {
            this.fa = new OrganicLayouter();
        }
    }
}

