/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import twaver.Node;
import twaver.base.A.E.O;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.BaseElementSVGUI;

public class NodeSVGUI
extends BaseElementSVGUI {
    private Node P = null;

    public NodeSVGUI(TSVGNetwork network, Node node) {
        super(network, node);
        this.P = node;
    }

    protected String getImageUrl() {
        return this.element.getImageURL();
    }

    protected SVGStruct toDefaultBodySVG(SVGContext context) {
        if (this.element.getImage() == null) {
            return super.toDefaultBodySVG(context);
        }
        float alpha = this.getRenderAlpha();
        Color color = this.getPaintBodyColor(null);
        Rectangle elementBounds = this.element.getBounds();
        Point location = this.element.getLocation();
        String url = this.getImageUrl();
        Rectangle bounds = new Rectangle(location.x, location.y, (int)elementBounds.getWidth(), (int)elementBounds.getHeight());
        StringBuffer sb = new StringBuffer();
        I.A(context, sb, url, color, bounds, alpha);
        if (this.element.getTextureFactory() != null) {
            if (color == null) {
                color = this.P.getBodyColor();
            }
            Object fillObject = this.getFillObject(context, color);
            I.A(context, sb, bounds, fillObject, null, (Object)"1", alpha, 0.0, null);
        }
        Shape shape = null;
        if (this.P.isDrawImageShape() && (shape = O.C(url)) != null) {
            AffineTransform at = AffineTransform.getTranslateInstance(location.x, location.y);
            shape = at.createTransformedShape(shape);
        }
        if (shape == null) {
            shape = bounds;
        }
        Rectangle outlineBounds = shape.getBounds();
        this.appendDefaultStateOutline(sb, context, outlineBounds);
        return new SVGStruct(sb.toString(), bounds);
    }
}

