/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.context;

import com.nepxion.util.context.AbstractContextRegister;
import com.nepxion.util.context.ContextConstants;
import com.nepxion.util.database.pool.proxool.ProxoolContext;
import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.io.FileContext;
import com.nepxion.util.locale.LocaleContext;
import com.nepxion.util.log.LoggerContext;
import com.nepxion.util.net.http.HttpContext;
import com.nepxion.util.net.url.URLContext;
import com.nepxion.util.scheduler.quartz.QuartzContext;
import com.nepxion.util.searcher.ip.local.IPContext;
import java.net.URL;
import java.util.Properties;

public class ContextRegister
extends AbstractContextRegister
implements ContextConstants {
    protected Properties properties;
    protected URL codeBase;

    @Override
    public void initializeContext(Properties properties) {
        this.initializeContext(null, properties);
    }

    @Override
    public void initializeContext(URL codeBase, Properties properties) {
        this.properties = properties;
        this.codeBase = codeBase;
        this.initEncoder();
        this.initLocale();
        this.initLogger();
        this.initHttp();
        this.initURL();
        this.initDBConnectionPool();
        this.initScheduler();
        this.initIp();
        this.initZone();
    }

    private void initEncoder() {
        String httpCharset;
        String ioCharset = this.properties.getProperty("ioCharset");
        if (this.isValid(ioCharset)) {
            EncoderContext.registerIOCharset(ioCharset);
        }
        if (this.isValid(httpCharset = this.properties.getProperty("httpCharset"))) {
            EncoderContext.registerHttpCharset(httpCharset);
        }
    }

    private void initLocale() {
        String locale = this.properties.getProperty("locale");
        if (this.isValid(locale)) {
            LocaleContext.registerLocale(locale);
        }
    }

    private void initLogger() {
        String loggerEnabled = this.properties.getProperty("logger-3rd-enabled");
        boolean isLoggerEnabled = false;
        if (this.isValid(loggerEnabled)) {
            isLoggerEnabled = loggerEnabled.equals("true");
        }
        if (isLoggerEnabled) {
            try {
                if (this.codeBase == null) {
                    LoggerContext.register();
                } else {
                    LoggerContext.register(this.codeBase);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initHttp() {
        String httpEnabled = this.properties.getProperty("http-3rd-enabled");
        boolean isHttpEnabled = false;
        if (this.isValid(httpEnabled)) {
            isHttpEnabled = httpEnabled.equals("true");
        }
        if (isHttpEnabled) {
            try {
                if (this.codeBase == null) {
                    HttpContext.register();
                } else {
                    HttpContext.register(this.codeBase);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initURL() {
        String urlEnabled = this.properties.getProperty("url-3rd-enabled");
        boolean isURLEnabled = false;
        if (this.isValid(urlEnabled)) {
            isURLEnabled = urlEnabled.equals("true");
        }
        if (isURLEnabled) {
            try {
                if (this.codeBase == null) {
                    URLContext.register();
                } else {
                    URLContext.register(this.codeBase);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initDBConnectionPool() {
        String dbConnectionPoolEnabled = this.properties.getProperty("dbConnectionPool-3rd-enabled");
        boolean isDBConnectionPoolEnabled = false;
        if (this.isValid(dbConnectionPoolEnabled)) {
            isDBConnectionPoolEnabled = dbConnectionPoolEnabled.equals("true");
        }
        if (isDBConnectionPoolEnabled) {
            try {
                if (this.codeBase == null) {
                    ProxoolContext.register();
                } else {
                    ProxoolContext.register(this.codeBase);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initScheduler() {
        String schedulerEnabled = this.properties.getProperty("scheduler-3rd-enabled");
        boolean isSchedulerEnabled = false;
        if (this.isValid(schedulerEnabled)) {
            isSchedulerEnabled = schedulerEnabled.equals("true");
        }
        if (isSchedulerEnabled) {
            try {
                if (this.codeBase == null) {
                    QuartzContext.register();
                } else {
                    QuartzContext.register(this.codeBase);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initIp() {
        String ipEnabled = this.properties.getProperty("ip-3rd-enabled");
        boolean isIpEnabled = false;
        if (this.isValid(ipEnabled)) {
            isIpEnabled = ipEnabled.equals("true");
        }
        if (isIpEnabled) {
            try {
                if (this.codeBase == null) {
                    IPContext.register();
                } else {
                    IPContext.register(this.codeBase);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initZone() {
        String zoneEnabled = this.properties.getProperty("zone-3rd-enabled");
        boolean isZoneEnabled = false;
        if (this.isValid(zoneEnabled)) {
            isZoneEnabled = zoneEnabled.equals("true");
        }
        if (isZoneEnabled) {
            try {
                if (this.codeBase == null) {
                    FileContext.register("data/zone.xml");
                } else {
                    FileContext.register(this.codeBase, "data/zone.xml");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isValid(String content) {
        return content != null && !content.trim().equals("");
    }
}

