/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.swingworker;

import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.swingworker.PropertyChangeAdapter;
import java.awt.Component;
import org.jdesktop.swingworker.SwingWorker;

public abstract class JSwingWorker
extends SwingWorker {
    private Component component;

    public JSwingWorker() {
        this(null);
    }

    public JSwingWorker(Component component) {
        this.component = component;
        this.addPropertyChangeListener(new PropertyChangeAdapter(){

            @Override
            public void firePendingStatusChanged() {
                JSwingWorker.this.firePendingStatusChanged();
            }

            @Override
            public void fireStartedStatusChanged() {
                JSwingWorker.this.fireStartedStatusChanged();
            }

            @Override
            public void fireDoneStatusChanged() {
                JSwingWorker.this.fireDoneStatusChanged();
            }

            @Override
            public void fireProgressValueChanged(Object value) {
                JSwingWorker.this.fireProgressValueChanged(value);
            }
        });
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    protected void done() {
        block7: {
            if (this.isCancelled()) {
                this.fireCancelledStatusChanged();
                return;
            }
            Object data = null;
            try {
                data = this.get();
            }
            catch (Exception e) {
                data = e;
            }
            if (data instanceof Exception) {
                e = (Exception)data;
                this.fireForegroundException(e);
                if (this.component != null) {
                    ExceptionTracer.traceException(HandleManager.getFrame(this.component), e);
                }
            }
            try {
                this.loadForeground(data);
            }
            catch (Exception e) {
                this.fireForegroundException(e);
                if (this.component == null) break block7;
                ExceptionTracer.traceException(HandleManager.getFrame(this.component), e);
            }
        }
    }

    protected Object doInBackground() throws Exception {
        Object data;
        block2: {
            data = null;
            try {
                data = this.loadBackground();
            }
            catch (Exception e) {
                if (this.isCancelled()) break block2;
                this.fireBackgroundException(e);
                throw e;
            }
        }
        return data;
    }

    public void firePendingStatusChanged() {
    }

    public void fireStartedStatusChanged() {
    }

    public void fireDoneStatusChanged() {
    }

    public void fireProgressValueChanged(Object value) {
    }

    public void fireCancelledStatusChanged() {
    }

    public void fireForegroundException(Exception e) {
    }

    public void fireBackgroundException(Exception e) {
    }

    protected abstract void loadForeground(Object var1) throws Exception;

    protected abstract Object loadBackground() throws Exception;
}

