/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.popupmenu;

import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.popupmenu.PopupMenuContext;
import com.nepxion.swing.popupmenu.PopupMenuManager;
import com.nepxion.swing.popupmenu.PopupMenuPainter;
import com.nepxion.swing.style.framework.IStyle;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPopupMenu;

public class JBasicPopupMenu
extends JPopupMenu {
    private PopupMenuPainter painter;

    public JBasicPopupMenu() {
        this(PopupMenuContext.getTitle());
    }

    public JBasicPopupMenu(PopupMenuPainter painter) {
        this.setPainter(painter);
    }

    public JBasicPopupMenu(String title) {
        this.setTitle(title);
    }

    public JBasicPopupMenu(IStyle style) {
        this.setStyle(style);
    }

    public PopupMenuPainter getPainter() {
        return this.painter;
    }

    public void setPainter(PopupMenuPainter painter) {
        this.painter = painter;
        this.painter.setPopupMenu(this);
        PopupMenuManager.setPreferenceStyle(this);
        ContainerManager.update(this);
    }

    public String getTitle() {
        return this.painter.getTitle();
    }

    public void setTitle(String title) {
        PopupMenuPainter painter = new PopupMenuPainter(title);
        this.setPainter(painter);
    }

    public void setStyle(IStyle style) {
        PopupMenuPainter painter = new PopupMenuPainter(style);
        this.setPainter(painter);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.painter != null) {
            return this.painter.getInsets((Insets)insets.clone());
        }
        return insets;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.painter != null) {
            this.painter.paintComponent(g);
        }
    }
}

