/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.button;

import com.nepxion.swing.button.ButtonConstants;
import com.nepxion.swing.button.ButtonManager;

public class ButtonContext
implements ButtonConstants {
    private static String buttonUIClass;
    private static String menuButtonUIClass;
    private static String splitButtonUIClass;
    private static String buttonStyleClass;

    public static String getButtonUIClassPrefix(String buttonUIClass) {
        if (buttonUIClass.indexOf("SplitButtonUI") > -1) {
            return buttonUIClass.substring(0, buttonUIClass.indexOf("SplitButtonUI"));
        }
        if (buttonUIClass.indexOf("MenuButtonUI") > -1) {
            return buttonUIClass.substring(0, buttonUIClass.indexOf("MenuButtonUI"));
        }
        if (buttonUIClass.indexOf("ButtonUI") > -1) {
            return buttonUIClass.substring(0, buttonUIClass.indexOf("ButtonUI"));
        }
        return "";
    }

    public static void registerUI(String buttonUIClass, String buttonStyleClass) {
        String buttonUIPrefix = ButtonContext.getButtonUIClassPrefix(buttonUIClass);
        ButtonContext.buttonUIClass = buttonUIPrefix + "ButtonUI";
        menuButtonUIClass = buttonUIPrefix + "MenuButtonUI";
        splitButtonUIClass = buttonUIPrefix + "SplitButtonUI";
        ButtonContext.buttonStyleClass = buttonStyleClass;
    }

    public static void registerUI(String buttonUIClass, String menuButtonUIClass, String splitButtonUIClass, String buttonStyleClass) {
        ButtonContext.buttonUIClass = buttonUIClass;
        ButtonContext.menuButtonUIClass = menuButtonUIClass;
        ButtonContext.splitButtonUIClass = splitButtonUIClass;
        ButtonContext.buttonStyleClass = buttonStyleClass;
    }

    public static String getButtonUIClass() {
        return buttonUIClass;
    }

    public static String getMenuButtonUIClass() {
        return menuButtonUIClass;
    }

    public static String getSplitButtonUIClass() {
        return splitButtonUIClass;
    }

    public static String getButtonStyleClass() {
        return buttonStyleClass;
    }

    public static boolean setPriorityContext() {
        if (buttonUIClass != null && menuButtonUIClass != null && splitButtonUIClass != null && buttonStyleClass != null) {
            ButtonManager.setUI(buttonUIClass, menuButtonUIClass, splitButtonUIClass, buttonStyleClass);
            return true;
        }
        return false;
    }
}

