/*
 * Decompiled with CFR 0.152.
 */
package twaver.animate;

import java.awt.geom.Point2D;
import java.util.Map;
import twaver.Element;
import twaver.animate.AnimateProperty;

public class AnimateLocation
extends AnimateProperty {
    public AnimateLocation(Map newLocations) {
        this(newLocations, null);
    }

    public AnimateLocation(Map newLocations, Runnable runnable) {
        this(newLocations, runnable, -1, -1);
    }

    public AnimateLocation(Map newLocations, Runnable runnable, int stepSize, int sleep) {
        super(newLocations, runnable, stepSize, sleep);
    }

    public Object getPropertyValue(Element element) {
        return element.getLocation();
    }

    public void step(int stepIndex, Element element, Object oldPropertyValue, Object newPropertyValue) {
        Point2D oldLocation = (Point2D)oldPropertyValue;
        Point2D newLocation = (Point2D)newPropertyValue;
        double x = oldLocation.getX() + (double)stepIndex * (newLocation.getX() - oldLocation.getX()) / (double)this.stepSize;
        double y = oldLocation.getY() + (double)stepIndex * (newLocation.getY() - oldLocation.getY()) / (double)this.stepSize;
        element.setLocation(x, y);
    }
}

