/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.element;

import com.nepxion.cots.twaver.element.TElement;
import com.nepxion.cots.twaver.element.TGroupType;
import com.nepxion.cots.twaver.locale.TLocale;
import java.awt.Color;
import twaver.Element;
import twaver.GeoCoordinate;
import twaver.Group;
import twaver.TDataBox;
import twaver.TWaverUtil;

public class TGroup
extends Group
implements TElement {
    private boolean isMovable = true;
    private boolean isLeaf = false;
    private boolean isCategory = false;
    private boolean isSpecial = false;
    private boolean isDeletePermitted = true;

    public TGroup() {
        this("");
    }

    public TGroup(Object id) {
        super(id);
        this.initComponents();
    }

    public TGroup(String name) {
        this(name, false);
    }

    public TGroup(String name, boolean isExpand) {
        this(name, TGroupType.PARALLELOGRAM_GROUP_TYPE, isExpand);
    }

    public TGroup(String name, TGroupType groupType, boolean isExpand) {
        this(name, groupType.getType(), isExpand);
    }

    public TGroup(String name, int groupType, boolean isExpand) {
        this.setName(name);
        this.setGroupType(groupType);
        this.setExpand(isExpand);
        this.initComponents();
    }

    private void initComponents() {
        this.putClientProperty("label.yoffset", TWaverUtil.valueOf((int)4));
        this.putGroupAntialias(true);
        this.putGroupFill(true);
        this.putGroupFillColor(new Color(0, 0, 102, 255));
        this.putGroupGradient(true);
        this.putGroupDeep(10);
        this.putGroupGradientFactory(26);
        this.putGroup3D(true);
        this.putGroupAngle(45);
    }

    public GeoCoordinate getGeoCoordinate() {
        GeoCoordinate geoCoordinate = (GeoCoordinate)this.getClientProperty("geocoordinates");
        return geoCoordinate;
    }

    public void setGeoCoordinate(GeoCoordinate geoCoordinate) {
        this.putClientProperty("geocoordinates", geoCoordinate);
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
        if (this.isMovable) {
            this.removeAttachment("pin");
        } else {
            this.addAttachment("pin");
        }
    }

    public Element copy() {
        TGroup group = (TGroup)super.copy();
        this.copyProperty(group, true);
        return group;
    }

    public Element copy(Object id) {
        TGroup group = (TGroup)super.copy(id);
        this.copyProperty(group, true);
        return group;
    }

    public Element copy(TDataBox box) {
        TGroup group = (TGroup)super.copy(box);
        this.copyProperty(group, true);
        return group;
    }

    public Element copy(Object id, TDataBox box) {
        TGroup group = (TGroup)super.copy(id, box);
        this.copyProperty(group, true);
        return group;
    }

    public Element copyAll() {
        TGroup group = (TGroup)super.copy();
        this.copyProperty(group, false);
        group.setUserObject(this.getUserObject());
        return group;
    }

    private void copyProperty(TGroup group, boolean changeName) {
        if (changeName) {
            group.setName(TLocale.getString("element_copied") + " " + this.getName());
        }
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Override
    public boolean isCategory() {
        return this.isCategory;
    }

    @Override
    public void setCategory(boolean isCategory) {
        this.isCategory = isCategory;
    }

    @Override
    public boolean isSpecial() {
        return this.isSpecial;
    }

    @Override
    public void setSpecial(boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    @Override
    public boolean isDeletePermitted() {
        return this.isDeletePermitted;
    }

    @Override
    public void setDeletePermitted(boolean isDeletePermitted) {
        this.isDeletePermitted = isDeletePermitted;
    }

    public String toString() {
        return this.getName();
    }
}

