/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tip.balloon;

import com.nepxion.swing.border.BalloonBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public abstract class AbstractBalloonTip
extends JPanel {
    public static final Color TIP_COLOR = new Color(255, 255, 225);
    public static final int TIP_OFFSET = 10;
    private Component component;
    private JLayeredPane parentLayeredPane;

    public AbstractBalloonTip(Component component, Color tipColor, int tipOffset) {
        this.component = component;
        this.setOpaque(false);
        this.setBorder(new BalloonBorder(tipColor, tipOffset));
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (AbstractBalloonTip.this.isVisible()) {
                    AbstractBalloonTip.this.validateBounds();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (AbstractBalloonTip.this.isVisible()) {
                    AbstractBalloonTip.this.validateBounds();
                }
            }
        });
        component.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (AbstractBalloonTip.this.isVisible()) {
                    AbstractBalloonTip.this.validateBounds();
                }
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                if (AbstractBalloonTip.this.isVisible()) {
                    AbstractBalloonTip.this.validateBounds();
                }
            }
        });
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (AbstractBalloonTip.this.isVisible()) {
                    AbstractBalloonTip.this.setVisible(false);
                }
            }
        });
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AbstractBalloonTip.this.isVisible()) {
                    AbstractBalloonTip.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.validateBounds();
            this.validateLayeredPane();
        }
        super.setVisible(visible);
    }

    protected void validateBounds() {
        Point location = this.getPointOfLayeredPane(this.component);
        this.setBounds(location.x, location.y - this.getPreferredSize().height, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    protected void validateLayeredPane() {
        Container parent = this.component.getParent();
        JLayeredPane layeredPane = null;
        while (true) {
            if (parent == null) {
                return;
            }
            if (parent instanceof JFrame) {
                layeredPane = ((JFrame)parent).getLayeredPane();
                break;
            }
            if (parent instanceof JDialog) {
                layeredPane = ((JDialog)parent).getLayeredPane();
                break;
            }
            if (parent instanceof JApplet) {
                layeredPane = ((JApplet)parent).getLayeredPane();
                break;
            }
            parent = parent.getParent();
        }
        if (this.parentLayeredPane == layeredPane) {
            return;
        }
        layeredPane.add((Component)this, JLayeredPane.POPUP_LAYER);
        this.parentLayeredPane = layeredPane;
    }

    protected Point getPointOfLayeredPane(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component can't be null");
        }
        int x = component.getX();
        int y = component.getY();
        Container parent = component.getParent();
        while (true) {
            if (parent == null) {
                return new Point(x, y);
            }
            if (parent instanceof JLayeredPane) break;
            x += parent.getX();
            y += parent.getY();
            parent = parent.getParent();
        }
        return new Point(x, y);
    }
}

