/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowBevelIcon
implements Icon,
SwingConstants {
    private static final int DEFAULT_SIZE = 11;
    private Color edgeColor1;
    private Color edgeColor2;
    private Color fillColor;
    private int size;
    private int direction;

    public ArrowBevelIcon(int direction, boolean isRaisedView, boolean isPressedView) {
        if (isRaisedView) {
            if (isPressedView) {
                this.initialize(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"), 11, direction);
            } else {
                this.initialize(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), 11, direction);
            }
        } else if (isPressedView) {
            this.initialize(UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"), 11, direction);
        } else {
            this.initialize(UIManager.getColor("controlShadow"), UIManager.getColor("controlHighlight"), UIManager.getColor("control"), 11, direction);
        }
    }

    public ArrowBevelIcon(Color edgeColor1, Color edgeColor2, Color fillColor, int size, int direction) {
        this.initialize(edgeColor1, edgeColor2, fillColor, size, direction);
    }

    private void initialize(Color edgeColor1, Color edgeColor2, Color fillColor, int size, int direction) {
        this.edgeColor1 = edgeColor1;
        this.edgeColor2 = edgeColor2;
        this.fillColor = fillColor;
        this.size = size;
        this.direction = direction;
    }

    private void paintUpArrow(Graphics g, int i, int j) {
        g.setColor(this.edgeColor1);
        int x = i + this.size / 2;
        g.drawLine(x, j, x, j);
        --x;
        int y = j + 1;
        int dx = 0;
        while (y + 3 < j + this.size) {
            g.setColor(this.edgeColor1);
            g.drawLine(x, y, x + 1, y);
            g.drawLine(x, y + 1, x + 1, y + 1);
            if (0 < dx) {
                g.setColor(this.fillColor);
                g.drawLine(x + 2, y, x + 1 + dx, y);
                g.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
            }
            g.setColor(this.edgeColor2);
            g.drawLine(x + dx + 2, y, x + dx + 3, y);
            g.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
            --x;
            y += 2;
            dx += 2;
        }
        g.setColor(this.edgeColor1);
        g.drawLine(i, j + this.size - 3, i + 1, j + this.size - 3);
        g.setColor(this.edgeColor2);
        g.drawLine(i + 2, j + this.size - 2, i + this.size - 1, j + this.size - 2);
        g.drawLine(i, j + this.size - 1, i + this.size, j + this.size - 1);
    }

    private void paintDownArrow(Graphics g, int i, int j) {
        g.setColor(this.edgeColor1);
        g.drawLine(i, j, i + this.size - 1, j);
        g.drawLine(i, j + 1, i + this.size - 3, j + 1);
        g.setColor(this.edgeColor2);
        g.drawLine(i + this.size - 2, j + 1, i + this.size - 1, j + 1);
        int x = i + 1;
        int y = j + 2;
        int dx = this.size - 6;
        while (y + 1 < j + this.size) {
            g.setColor(this.edgeColor1);
            g.drawLine(x, y, x + 1, y);
            g.drawLine(x, y + 1, x + 1, y + 1);
            if (0 < dx) {
                g.setColor(this.fillColor);
                g.drawLine(x + 2, y, x + 1 + dx, y);
                g.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
            }
            g.setColor(this.edgeColor2);
            g.drawLine(x + dx + 2, y, x + dx + 3, y);
            g.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
            ++x;
            y += 2;
            dx -= 2;
        }
        g.setColor(this.edgeColor1);
        g.drawLine(i + this.size / 2, j + this.size - 1, i + this.size / 2, j + this.size - 1);
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        switch (this.direction) {
            case 1: {
                this.paintUpArrow(g, x, y);
                break;
            }
            case 5: {
                this.paintDownArrow(g, x, y);
            }
        }
    }
}

