/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.gis;

import com.nepxion.cots.twaver.gis.TGisGraph;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.statusbar.JStatusBar;
import com.nepxion.swing.statusbar.JStatusItem;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import twaver.gis.gadget.StatusBar;

public class TGisGraphScaleBar
extends JStatusBar {
    public TGisGraphScaleBar(TGisGraph gisGraph) {
        this.setSeparatorHeight(13);
        final JLabel zoomLabel = new JLabel(TIconFactory.getContextIcon("zoom.png"));
        JLabel positionLabel = new JLabel(TIconFactory.getContextIcon("scale.png"));
        JStatusItem positionStatusItem = new JStatusItem((Component)positionLabel);
        final JLabel longitudeLabel = new JLabel();
        JStatusItem longitudeStatusItem = new JStatusItem((Component)longitudeLabel);
        final JLabel latitudeLabel = new JLabel();
        JStatusItem latitudeStatusItem = new JStatusItem((Component)latitudeLabel);
        final JLabel distanceLabel = new JLabel(TIconFactory.getContextIcon("distance.png"));
        StatusBar statusBar = new StatusBar(gisGraph.getMap(), gisGraph.getCanvas());
        JLabel tZoomLabel = (JLabel)statusBar.getComponent(0);
        tZoomLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String zoom = (String)e.getNewValue();
                TGisGraphScaleBar.this.setZoom(zoomLabel, zoom);
            }
        });
        this.setZoom(zoomLabel, tZoomLabel.getText());
        JLabel tLongitudeLabel = (JLabel)statusBar.getComponent(2);
        tLongitudeLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String longitude = (String)e.getNewValue();
                TGisGraphScaleBar.this.setLongitude(longitudeLabel, longitude);
            }
        });
        this.setLongitude(longitudeLabel, tLongitudeLabel.getText());
        JLabel tLatitudeLabel = (JLabel)statusBar.getComponent(4);
        tLatitudeLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String latitude = (String)e.getNewValue();
                TGisGraphScaleBar.this.setLatitude(latitudeLabel, latitude);
            }
        });
        this.setLatitude(latitudeLabel, tLatitudeLabel.getText());
        JLabel tDistanceLabel = (JLabel)statusBar.getComponent(6);
        tDistanceLabel.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String distance = (String)e.getNewValue();
                TGisGraphScaleBar.this.setDistance(distanceLabel, distance);
            }
        });
        this.setDistance(distanceLabel, tDistanceLabel.getText());
        this.addItem(new JStatusItem((Component)zoomLabel), 80, 2, "LoweredStyle", true);
        this.addItem(positionStatusItem, 20, 2, "LoweredStyle", false);
        this.addItem(longitudeStatusItem, 120, 2, "LoweredStyle", false);
        this.addItem(latitudeStatusItem, 120, 2, "LoweredStyle", true);
        this.addItem(new JStatusItem((Component)distanceLabel), 160, 2, "LoweredStyle", false);
    }

    private void setZoom(JLabel zoomLabel, String zoom) {
        zoom = zoom.substring(zoom.indexOf(":") + 1).trim();
        zoomLabel.setText(TLocale.getString("graph_zoom") + ":" + zoom);
    }

    private void setLongitude(JLabel longitudeLabel, String longitude) {
        longitude = longitude.substring(longitude.indexOf(":") + 1).trim();
        longitudeLabel.setText("<html>" + TLocale.getString("graph_longitude") + ":" + longitude);
    }

    private void setLatitude(JLabel latitudeLabel, String latitude) {
        latitude = latitude.substring(latitude.indexOf(":") + 1).trim();
        latitudeLabel.setText("<html>" + TLocale.getString("graph_latitude") + ":" + latitude);
    }

    private void setDistance(JLabel distanceLabel, String distance) {
        distance = distance.substring(distance.indexOf(":") + 1).trim();
        distanceLabel.setText(TLocale.getString("graph_distance") + ":" + distance);
    }
}

