/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.gis;

import com.nepxion.cots.twaver.gis.TGisGraph;
import com.nepxion.cots.twaver.gis.TGisGraphController;
import com.nepxion.cots.twaver.gis.TMapType;
import com.nepxion.cots.twaver.graph.TGraphControlBar;
import com.nepxion.cots.twaver.graph.TGraphController;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.button.JBasicMenuButton;
import com.nepxion.swing.button.JBasicToggleButton;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.menuitem.JBasicRadioButtonMenuItem;
import com.nepxion.swing.outlookbar.JFlatOutlook;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TGisGraphControlBarGenerator {
    public TGisGraphControlBarGenerator(TGisGraph gisGraph) {
        TGraphControlBar controlBar = (TGraphControlBar)((Object)gisGraph.getControlBarInternalFrame().getContent());
        JFlatOutlook viewOutlook = controlBar.getViewToolBar().getViewOutlook();
        viewOutlook.removeAll();
        double[][] size = new double[][]{{30.0, 30.0}, {-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0}};
        viewOutlook.setLayout((LayoutManager)new TableLayout((double[][])size));
        JBasicToggleButton selectButton = new JBasicToggleButton((Action)TGisGraphController.getSelectAction(gisGraph));
        selectButton.setSelected(true);
        selectButton.setText("");
        viewOutlook.add((Component)selectButton, (Object)"0, 0");
        JBasicToggleButton panButton = new JBasicToggleButton((Action)TGisGraphController.getPanAction(gisGraph));
        panButton.setText("");
        viewOutlook.add((Component)panButton, (Object)"0, 1");
        JBasicToggleButton lazeMoveButton = new JBasicToggleButton((Action)TGraphController.getLazyMoveAction(gisGraph));
        lazeMoveButton.setText("");
        viewOutlook.add((Component)lazeMoveButton, (Object)"1, 1");
        JBasicToggleButton zoomInButton = new JBasicToggleButton((Action)TGisGraphController.getZoomInAction(gisGraph));
        zoomInButton.setText("");
        viewOutlook.add((Component)zoomInButton, (Object)"0, 2");
        JBasicToggleButton zoomOutButton = new JBasicToggleButton((Action)TGisGraphController.getZoomOutAction(gisGraph));
        zoomOutButton.setText("");
        viewOutlook.add((Component)zoomOutButton, (Object)"1, 2");
        JBasicButton zoomResetButton = new JBasicButton((Action)TGisGraphController.getZoomResetAction(gisGraph));
        zoomResetButton.setText("");
        viewOutlook.add((Component)zoomResetButton, (Object)"0, 3");
        JBasicToggleButton magnifierButton = new JBasicToggleButton((Action)TGraphController.getMagnifierAction(gisGraph));
        magnifierButton.setText("");
        viewOutlook.add((Component)magnifierButton, (Object)"0, 4");
        JBasicPopupMenu mapPopupMenu = new JBasicPopupMenu();
        ButtonGroup mapTypeButtonGroup = new ButtonGroup();
        TMapType[] mapTypes = new TMapType[]{TMapType.GOOGLE_MAP_TYPE, TMapType.GOOGLE_SATELLITE_MAP_TYPE, TMapType.GOOGLE_TERRAIN_MAP_TYPE, TMapType.MICROSOFT_BINT_MAP_TYPE, TMapType.OPENSTREET_MAP_TYPE, TMapType.MAPABC_MAP_TYPE, TMapType.TIANDITU_MAP_TYPE};
        for (int i = 0; i < mapTypes.length; ++i) {
            TMapType mapType = mapTypes[i];
            JBasicRadioButtonMenuItem mapTypeMenuItem = new JBasicRadioButtonMenuItem((Action)TGisGraphController.getMapTypeConfigAction(gisGraph, mapType));
            mapPopupMenu.add((JMenuItem)mapTypeMenuItem);
            if (mapType == TMapType.MAPABC_MAP_TYPE) {
                mapTypeMenuItem.doClick();
            }
            mapTypeButtonGroup.add((AbstractButton)mapTypeMenuItem);
        }
        JBasicMenuButton mapButton = new JBasicMenuButton((Icon)TIconFactory.getContextIcon("map.png"));
        mapButton.setPopupMenu((JPopupMenu)mapPopupMenu);
        viewOutlook.add((Component)mapButton, (Object)"1, 4");
        JBasicButton zoomButton = new JBasicButton((Action)TGisGraphController.getZoomBackAction(gisGraph));
        zoomButton.setText("");
        viewOutlook.add((Component)zoomButton, (Object)"1, 3");
        JBasicToggleButton scaleButton = new JBasicToggleButton((Action)TGisGraphController.getScaleAction(gisGraph));
        scaleButton.setText("");
        scaleButton.setGrouped(false);
        viewOutlook.add((Component)scaleButton, (Object)"0, 5");
        JBasicToggleButton distanceButton = new JBasicToggleButton((Action)TGisGraphController.getDistanceAction(gisGraph));
        distanceButton.setText("");
        viewOutlook.add((Component)distanceButton, (Object)"1, 5");
        JBasicButton fullscreenButton = new JBasicButton((Action)TGraphController.getFullScreenAction(gisGraph));
        fullscreenButton.setText("");
        viewOutlook.add((Component)fullscreenButton, (Object)"0, 6");
        JBasicToggleButton overviewButton = new JBasicToggleButton((Action)TGisGraphController.getOverviewAction(gisGraph));
        overviewButton.setText("");
        overviewButton.setGrouped(false);
        viewOutlook.add((Component)overviewButton, (Object)"1, 6");
        JBasicToggleButton navigatorButton = new JBasicToggleButton((Action)TGisGraphController.getNavigatorAction(gisGraph));
        navigatorButton.setSelected(true);
        navigatorButton.setText("");
        navigatorButton.setGrouped(false);
        viewOutlook.add((Component)navigatorButton, (Object)"0, 7");
        ButtonManager.updateUI((Container)viewOutlook, (Dimension)new Dimension(25, 25), (ButtonGroup)new ButtonGroup());
    }
}

