/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.io;

import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class ZipUtil {
    public static List getZipFileList(String filePath, boolean classLoader) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        return ZipUtil.getZipFileList(filePath, EncoderContext.getIOCharset(), classLoader);
    }

    public static List getZipFileList(String filePath, String charset, boolean classLoader) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        ArrayList<String> list = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = ZipUtil.getZipReader(filePath, charset, classLoader);
            if (bufferedReader == null) {
                List list2 = null;
                return list2;
            }
            list = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() == 0) {
                    break;
                }
                list.add(line);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return list;
    }

    public static BufferedReader getZipReader(String filePath, boolean classLoader) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        return ZipUtil.getZipReader(filePath, EncoderContext.getIOCharset(), classLoader);
    }

    public static BufferedReader getZipReader(String filePath, String charset, boolean classLoader) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        InputStream inputStream = FileUtil.getInputStream(filePath, classLoader);
        GZIPInputStream zipInputStream = new GZIPInputStream(inputStream);
        return new BufferedReader(new InputStreamReader((InputStream)zipInputStream, charset));
    }
}

