/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.textfield;

import com.nepxion.swing.textcomponent.TextPopupMenuAdapter;
import com.nepxion.swing.textfield.TextFieldManager;
import com.nepxion.swing.tip.balloon.BalloonTipDecoration;
import com.nepxion.swing.tip.balloon.JBalloonTip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class JBasicTextField
extends JTextField
implements ActionListener,
FocusListener {
    private boolean isEnterAcceleratorSupported;
    private boolean isSelectionAllSupported;
    private BalloonTipDecoration toolTipDecoration;
    private TextPopupMenuAdapter popupMenuAdapter;

    public JBasicTextField() {
        this.initComponents();
    }

    public JBasicTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initComponents();
    }

    public JBasicTextField(int columns) {
        super(columns);
        this.initComponents();
    }

    public JBasicTextField(String text, int columns) {
        super(text, columns);
        this.initComponents();
    }

    public JBasicTextField(String text) {
        super(text);
        this.initComponents();
    }

    private void initComponents() {
        this.popupMenuAdapter = new TextPopupMenuAdapter(this);
        this.toolTipDecoration = new BalloonTipDecoration(this);
        this.supportEnterAccelerator(true);
    }

    public boolean isEnterAcceleratorSupported() {
        return this.isEnterAcceleratorSupported;
    }

    public void supportEnterAccelerator(boolean isEnterAcceleratorSupported) {
        this.isEnterAcceleratorSupported = isEnterAcceleratorSupported;
        if (isEnterAcceleratorSupported) {
            this.addActionListener(this);
        } else {
            this.removeActionListener(this);
        }
    }

    public boolean isSelectionAllSupported() {
        return this.isSelectionAllSupported;
    }

    public void supportSelectionAll(boolean isSelectionAllSupported) {
        this.isSelectionAllSupported = isSelectionAllSupported;
        if (isSelectionAllSupported) {
            this.addFocusListener(this);
        } else {
            this.removeFocusListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.transferFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public TextPopupMenuAdapter getPopupMenuAdapter() {
        return this.popupMenuAdapter;
    }

    public void showTip(String tipText) {
        this.showTip(tipText, JBalloonTip.TIP_ICON_ERROR, 2, 16);
    }

    public void showTip(String tipText, int rows, int columns) {
        this.showTip(tipText, JBalloonTip.TIP_ICON_ERROR, rows, columns);
    }

    public void showTip(String tipText, Icon tipIcon) {
        this.showTip(tipText, JBalloonTip.TIP_ICON_ERROR, 2, 16);
    }

    public void showTip(String tipText, Icon tipIcon, int rows, int columns) {
        JBalloonTip balloonTip = this.getBalloonTip();
        if (balloonTip.isVisible()) {
            return;
        }
        this.requestFocus();
        balloonTip.setMinimumRows(rows);
        balloonTip.setColumns(columns);
        balloonTip.setText(tipText);
        balloonTip.setIcon(tipIcon);
        balloonTip.setVisible(true);
    }

    public JBalloonTip getBalloonTip() {
        return this.toolTipDecoration.getBalloonTip();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.addMouseListener(this.popupMenuAdapter);
        } else {
            this.removeMouseListener(this.popupMenuAdapter);
        }
    }

    public void setLabelStyle() {
        TextFieldManager.setLabelStyle(this);
        this.removeMouseListener(this.popupMenuAdapter);
    }
}

