/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.file;

import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class JFileFilter
extends FileFilter {
    private List filterWords;
    private String filterDescription;

    public JFileFilter(List filterWords, String filterDescription) {
        this.filterWords = filterWords;
        this.filterDescription = filterDescription;
    }

    @Override
    public boolean accept(File file) {
        boolean accept = file.isDirectory();
        if (!accept) {
            String suffix = this.getSuffix(file);
            if (this.filterWords != null && suffix != null) {
                accept = this.filterWords.contains(suffix);
            }
        }
        return accept;
    }

    public List getWords() {
        return this.filterWords;
    }

    @Override
    public String getDescription() {
        return this.filterDescription;
    }

    public String getSuffix(File file) {
        String path = file.getPath();
        String suffix = null;
        int index = path.lastIndexOf(46);
        if (index > 0 && index < path.length() - 1) {
            suffix = path.substring(index + 1).toLowerCase();
        }
        return suffix;
    }
}

