/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.pagination;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.combobox.JBasicComboBox;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.pagination.PaginationContext;
import com.nepxion.swing.textfield.number.JNumberTextField;
import com.nepxion.swing.tip.balloon.JBalloonTip;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicLabelUI;

public abstract class PaginationBar
extends JPanel {
    private JLabel currentPageIndexLabel = this.createLabel("");
    private JLabel currentPageRowCountLabel = this.createLabel("");
    private JLabel totalPageCountLabel = this.createLabel("");
    private JLabel totalRowCountLabel = this.createLabel("");
    private JLabel maxPageRowCountLabel = this.createLabel("");
    private JBasicButton firstPageButton = new JBasicButton(IconFactory.getSwingIcon("stereo/control_top_16.png"), SwingLocale.getString("first_page"));
    private JBasicButton backwardPageButton;
    private JBasicButton forwardPageButton;
    private JBasicButton lastPageButton;
    private JNumberTextField pageIndexDirectTextField;
    private JBasicButton pageIndexDirectButton;
    private JNumberTextField maxPageRowCountDirectTextField;
    private JBasicButton maxPageRowCountDirectButton;
    private JBasicComboBox sortNameComboBox;
    private JBasicComboBox sortTypeComboBox;
    private JBasicButton submitSortButton;
    private JTable table;
    private JList list;
    private JPanel pageInfoPanel;
    private JPanel pageButtonPanel;
    private JPanel pageIndexDirectPanel;
    private JPanel maxPageRowCountDirectPanel;
    private JPanel sortPanel;
    private PaginationContext paginationContext;

    public PaginationBar(JTable table) {
        this(table, null);
    }

    public PaginationBar(JList list) {
        this(list, null);
    }

    public PaginationBar(JTable table, PaginationContext context) {
        this(context);
        this.table = table;
    }

    public PaginationBar(JList list, PaginationContext context) {
        this(context);
        this.list = list;
    }

    public PaginationBar(PaginationContext context) {
        this.firstPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                int currentPageIndex = PaginationBar.this.paginationContext.getCurrentPageIndex();
                if (isValidation && currentPageIndex == 1) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame(PaginationBar.this), SwingLocale.getString("first_page_description"), SwingLocale.getString("warning"), 2);
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setPageIndex(1);
                    PaginationBar.this.directRowIndex(PaginationBar.this.paginationContext.getRowIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.backwardPageButton = new JBasicButton(IconFactory.getSwingIcon("stereo/arrow_backward_16.png"), SwingLocale.getString("backward_page"));
        this.backwardPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                int currentPageIndex = PaginationBar.this.paginationContext.getCurrentPageIndex();
                if (isValidation && currentPageIndex == 1) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame(PaginationBar.this), SwingLocale.getString("first_page_description"), SwingLocale.getString("warning"), 2);
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setPageIndex(currentPageIndex - 1);
                    PaginationBar.this.directRowIndex(PaginationBar.this.paginationContext.getRowIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.forwardPageButton = new JBasicButton(IconFactory.getSwingIcon("stereo/arrow_forward_16.png"), SwingLocale.getString("forward_page"));
        this.forwardPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                int currentPageIndex = PaginationBar.this.paginationContext.getCurrentPageIndex();
                int totalPageCount = PaginationBar.this.paginationContext.getTotalPageCount();
                if (isValidation && currentPageIndex == totalPageCount) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame(PaginationBar.this), SwingLocale.getString("last_page_description"), SwingLocale.getString("warning"), 2);
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setPageIndex(currentPageIndex + 1);
                    PaginationBar.this.directRowIndex(PaginationBar.this.paginationContext.getRowIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.lastPageButton = new JBasicButton(IconFactory.getSwingIcon("stereo/control_bottom_16.png"), SwingLocale.getString("last_page"));
        this.lastPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                int currentPageIndex = PaginationBar.this.paginationContext.getCurrentPageIndex();
                int totalPageCount = PaginationBar.this.paginationContext.getTotalPageCount();
                if (isValidation && currentPageIndex == totalPageCount) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame(PaginationBar.this), SwingLocale.getString("last_page_description"), SwingLocale.getString("warning"), 2);
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setPageIndex(totalPageCount);
                    PaginationBar.this.directRowIndex(PaginationBar.this.paginationContext.getRowIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.pageIndexDirectTextField = new JNumberTextField(1.0);
        this.setPageIndexDirectTextFieldWidth(35);
        this.pageIndexDirectButton = new JBasicButton(IconFactory.getSwingIcon("stereo/control_go_16.png"), SwingLocale.getString("submit"));
        this.pageIndexDirectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pageIndexDirect = -1;
                try {
                    pageIndexDirect = Integer.parseInt(PaginationBar.this.pageIndexDirectTextField.getText());
                }
                catch (NumberFormatException ex) {
                    PaginationBar.this.pageIndexDirectTextField.showTip(SwingLocale.getString("invalid_page_count"), JBalloonTip.TIP_ICON_ERROR_MESSAGE, 1, 9);
                    return;
                }
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                int currentPageIndex = PaginationBar.this.paginationContext.getCurrentPageIndex();
                int totalPageCount = PaginationBar.this.paginationContext.getTotalPageCount();
                if (pageIndexDirect > totalPageCount) {
                    PaginationBar.this.pageIndexDirectTextField.showTip(SwingLocale.getString("page_count_not_more_than") + totalPageCount, JBalloonTip.TIP_ICON_ERROR_MESSAGE, 2, 12);
                    return;
                }
                if (isValidation && currentPageIndex == pageIndexDirect) {
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setPageIndex(pageIndexDirect);
                    PaginationBar.this.directRowIndex(PaginationBar.this.paginationContext.getRowIndex());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.maxPageRowCountDirectTextField = new JNumberTextField(1.0);
        this.setMaxPageRowCountDirectTextFieldWidth(35);
        this.maxPageRowCountDirectButton = new JBasicButton(IconFactory.getSwingIcon("stereo/control_go_16.png"), SwingLocale.getString("submit"));
        this.maxPageRowCountDirectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int maxPageRowCountDirect = -1;
                try {
                    maxPageRowCountDirect = Integer.parseInt(PaginationBar.this.maxPageRowCountDirectTextField.getText());
                }
                catch (NumberFormatException e1) {
                    PaginationBar.this.maxPageRowCountDirectTextField.showTip(SwingLocale.getString("item_count_not_null"));
                    return;
                }
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                int totalRowCount = PaginationBar.this.paginationContext.getTotalRowCount();
                if (maxPageRowCountDirect > totalRowCount) {
                    PaginationBar.this.maxPageRowCountDirectTextField.showTip(SwingLocale.getString("item_count_not_more_than") + totalRowCount);
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setPageIndex(1);
                    PaginationBar.this.paginationContext.setRowCount(maxPageRowCountDirect);
                    PaginationBar.this.directRowCount(maxPageRowCountDirect);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.sortNameComboBox = new JBasicComboBox();
        this.setSortNameComboBoxWidth(60);
        ArrayList<ElementNode> sortTypeList = new ArrayList<ElementNode>();
        ElementNode ascSortType = new ElementNode();
        ascSortType.setName("asc");
        ascSortType.setText(SwingLocale.getString("asc"));
        sortTypeList.add(ascSortType);
        ElementNode descSortType = new ElementNode();
        descSortType.setName("desc");
        descSortType.setText(SwingLocale.getString("desc"));
        sortTypeList.add(descSortType);
        this.sortTypeComboBox = new JBasicComboBox(sortTypeList.toArray());
        this.setSortTypeComboBoxWidth(60);
        this.submitSortButton = new JBasicButton(IconFactory.getSwingIcon("stereo/control_go_16.png"), SwingLocale.getString("submit"));
        this.submitSortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isValidation = PaginationBar.this.paginationContext.isValidation();
                ElementNode sortName = (ElementNode)PaginationBar.this.sortNameComboBox.getSelectedItem();
                ElementNode sortType = (ElementNode)PaginationBar.this.sortTypeComboBox.getSelectedItem();
                if (isValidation && PaginationBar.this.paginationContext.getSortName().getName().equals(sortName.getName()) && PaginationBar.this.paginationContext.getSortType().getName().equals(sortType.getName())) {
                    return;
                }
                try {
                    PaginationBar.this.clearRowDatas();
                    PaginationBar.this.paginationContext.setSortName(sortName);
                    PaginationBar.this.paginationContext.setSortType(sortType);
                    PaginationBar.this.sort(sortName, sortType);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        try {
            this.setPaginationContext(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(3, 1, 1, 1));
        this.initPageInfoPanel();
        this.initPageButtonPanel();
        this.initPageIndexDirectPanel();
        this.initMaxPageRowCountDirectPanel();
        this.initSortPanel();
        this.add(this.pageInfoPanel);
        this.add(Box.createHorizontalStrut(10));
        this.add(Box.createHorizontalGlue());
        this.add(this.pageButtonPanel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.pageIndexDirectPanel);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.maxPageRowCountDirectPanel);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.sortPanel);
    }

    private void initPageInfoPanel() {
        this.pageInfoPanel = new JPanel();
        this.pageInfoPanel.setLayout(new BoxLayout(this.pageInfoPanel, 0));
        this.pageInfoPanel.add(this.createLabel(SwingLocale.getString("sequence")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.currentPageIndexLabel);
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.createLabel(SwingLocale.getString("page")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(5));
        this.pageInfoPanel.add(this.currentPageRowCountLabel);
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.createLabel(SwingLocale.getString("item")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.createLabel(IconFactory.getSwingIcon("separator.png")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.createLabel(SwingLocale.getString("total")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.totalPageCountLabel);
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.createLabel(SwingLocale.getString("page")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(5));
        this.pageInfoPanel.add(this.totalRowCountLabel);
        this.pageInfoPanel.add(Box.createHorizontalStrut(2));
        this.pageInfoPanel.add(this.createLabel(SwingLocale.getString("item")));
        this.pageInfoPanel.add(Box.createHorizontalStrut(5));
    }

    private void initPageButtonPanel() {
        this.pageButtonPanel = new JPanel();
        this.pageButtonPanel.setLayout(new BoxLayout(this.pageButtonPanel, 0));
        this.pageButtonPanel.add(this.firstPageButton);
        this.pageButtonPanel.add(this.backwardPageButton);
        this.pageButtonPanel.add(this.forwardPageButton);
        this.pageButtonPanel.add(this.lastPageButton);
        ButtonManager.updateUI((Container)this.pageButtonPanel, new Dimension(22, 22));
    }

    private void initPageIndexDirectPanel() {
        this.pageIndexDirectPanel = new JPanel();
        this.pageIndexDirectPanel.setLayout(new BoxLayout(this.pageIndexDirectPanel, 0));
        this.pageIndexDirectPanel.add(this.createLabel(SwingLocale.getString("jump")));
        this.pageIndexDirectPanel.add(Box.createHorizontalStrut(2));
        this.pageIndexDirectPanel.add(this.pageIndexDirectTextField);
        this.pageIndexDirectPanel.add(Box.createHorizontalStrut(2));
        this.pageIndexDirectPanel.add(this.createLabel(SwingLocale.getString("page")));
        this.pageIndexDirectPanel.add(this.pageIndexDirectButton);
        ButtonManager.updateUI((Container)this.pageIndexDirectPanel, new Dimension(22, 22));
    }

    private void initMaxPageRowCountDirectPanel() {
        this.maxPageRowCountDirectPanel = new JPanel();
        this.maxPageRowCountDirectPanel.setLayout(new BoxLayout(this.maxPageRowCountDirectPanel, 0));
        this.maxPageRowCountDirectPanel.add(this.createLabel(SwingLocale.getString("a_page_has")));
        this.maxPageRowCountDirectPanel.add(Box.createHorizontalStrut(2));
        this.maxPageRowCountDirectPanel.add(this.maxPageRowCountDirectTextField);
        this.maxPageRowCountDirectPanel.add(Box.createHorizontalStrut(2));
        this.maxPageRowCountDirectPanel.add(this.createLabel(SwingLocale.getString("item")));
        this.maxPageRowCountDirectPanel.add(this.maxPageRowCountDirectButton);
        ButtonManager.updateUI((Container)this.maxPageRowCountDirectPanel, new Dimension(22, 22));
    }

    private void initSortPanel() {
        this.sortPanel = new JPanel();
        this.sortPanel.setLayout(new BoxLayout(this.sortPanel, 0));
        this.sortPanel.add(this.createLabel(SwingLocale.getString("sort")));
        this.sortPanel.add(Box.createHorizontalStrut(2));
        this.sortPanel.add(this.sortNameComboBox);
        this.sortPanel.add(Box.createHorizontalStrut(5));
        this.sortPanel.add(this.sortTypeComboBox);
        this.sortPanel.add(Box.createHorizontalStrut(2));
        this.sortPanel.add(this.submitSortButton);
        ButtonManager.updateUI((Container)this.sortPanel, new Dimension(22, 22));
    }

    private JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setUI(new BasicLabelUI());
        return label;
    }

    private JLabel createLabel(Icon icon) {
        JLabel label = new JLabel(icon);
        label.setUI(new BasicLabelUI());
        return label;
    }

    public void setSortNameComboBoxWidth(int width) {
        DimensionManager.setDimension(this.sortNameComboBox, new Dimension(width, 22));
    }

    public void setSortNameComboBoxPopupWidth(int width) {
        this.sortNameComboBox.setPopupMenuWidth(width);
    }

    public void setSortTypeComboBoxWidth(int width) {
        DimensionManager.setDimension(this.sortTypeComboBox, new Dimension(width, 22));
    }

    public void setSortTypeComboBoxPopupWidth(int width) {
        this.sortTypeComboBox.setPopupMenuWidth(width);
    }

    public void setPageIndexDirectTextFieldWidth(int width) {
        DimensionManager.setDimension(this.pageIndexDirectTextField, new Dimension(width, 22));
    }

    public void setMaxPageRowCountDirectTextFieldWidth(int width) {
        DimensionManager.setDimension(this.maxPageRowCountDirectTextField, new Dimension(width, 22));
    }

    private void setCurrentPageIndex(int currentPageIndex) {
        if (currentPageIndex < 1) {
            throw new IllegalArgumentException(SwingLocale.getString("page_index_not_less_than_1"));
        }
        this.currentPageIndexLabel.setText(currentPageIndex + "");
    }

    private void setCurrentPageRowCount(int currentPageRowCount) {
        if (currentPageRowCount < 0) {
            throw new IllegalArgumentException(SwingLocale.getString("current_item_count_not_less_than_0"));
        }
        this.currentPageRowCountLabel.setText(currentPageRowCount + "");
    }

    private void setTotalPageCount(int totalPageCount) {
        if (totalPageCount < 1) {
            throw new IllegalArgumentException(SwingLocale.getString("page_count_not_less_than_1"));
        }
        this.totalPageCountLabel.setText(totalPageCount + "");
    }

    private void setTotalRowCount(int totalRowCount) {
        if (totalRowCount < 0) {
            throw new IllegalArgumentException(SwingLocale.getString("total_count_not_less_than_0"));
        }
        this.totalRowCountLabel.setText(totalRowCount + "");
    }

    private void setMaxPageRowCount(int maxPageRowCount) {
        if (maxPageRowCount < 0) {
            throw new IllegalArgumentException(SwingLocale.getString("a_page_item_count_not_less_than_0"));
        }
        this.maxPageRowCountLabel.setText(maxPageRowCount + "");
    }

    public void setSortNameList(List sortNameList) {
        this.sortNameComboBox.setModel(new DefaultComboBoxModel<Object>(sortNameList.toArray()));
    }

    private void setSortName(ElementNode sortName) {
        this.sortNameComboBox.setSelectedItem(sortName);
    }

    public void setSortTypeList(List sortTypeList) {
        this.sortTypeComboBox.setModel(new DefaultComboBoxModel<Object>(sortTypeList.toArray()));
    }

    private void setSortType(ElementNode sortType) {
        this.sortTypeComboBox.setSelectedItem(sortType);
    }

    public boolean isAscending(ElementNode sortType) {
        return sortType.getName().equals("asc");
    }

    private void setPageIndexDirect(int pageIndexDirect) {
        if (pageIndexDirect < 1) {
            throw new IllegalArgumentException(SwingLocale.getString("page_index_not_less_than_1"));
        }
        this.pageIndexDirectTextField.setText(pageIndexDirect + "");
    }

    private void setMaxPageRowCountDirect(int maxPageRowCountDirect) {
        if (maxPageRowCountDirect < 1) {
            return;
        }
        this.maxPageRowCountDirectTextField.setText(maxPageRowCountDirect + "");
    }

    public JNumberTextField getPageIndexDirectTextField() {
        return this.pageIndexDirectTextField;
    }

    public JNumberTextField getMaxPageRowCountDirectTextField() {
        return this.maxPageRowCountDirectTextField;
    }

    public JBasicComboBox getSortNameComboBox() {
        return this.sortNameComboBox;
    }

    public JBasicComboBox getSortTypeComboBox() {
        return this.sortTypeComboBox;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        this.list = list;
    }

    public JPanel getPageInfoPanel() {
        return this.pageInfoPanel;
    }

    public JPanel getPageButtonPanel() {
        return this.pageButtonPanel;
    }

    public JPanel getPageIndexDirectPanel() {
        return this.pageIndexDirectPanel;
    }

    public JPanel getMaxPageRowCountDirectPanel() {
        return this.maxPageRowCountDirectPanel;
    }

    public JPanel getSortPanel() {
        return this.sortPanel;
    }

    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    public void setPaginationContext(PaginationContext paginationContext) throws Exception {
        if (paginationContext != null) {
            this.paginationContext = paginationContext;
            this.updatePagination();
            this.clearRowDatas();
        }
    }

    public void updatePagination() {
        this.setCurrentPageIndex(this.paginationContext.getCurrentPageIndex());
        this.setCurrentPageRowCount(this.paginationContext.getCurrentPageRowCount());
        this.setTotalPageCount(this.paginationContext.getTotalPageCount());
        this.setTotalRowCount(this.paginationContext.getTotalRowCount());
        this.setMaxPageRowCount(this.paginationContext.getRowCount());
        this.setPageIndexDirect(this.paginationContext.getCurrentPageIndex());
        this.setMaxPageRowCountDirect(this.paginationContext.getRowCount());
        if (this.paginationContext.getSortName() != null) {
            this.setSortName(this.paginationContext.getSortName());
        } else if (this.sortNameComboBox.getItemCount() != 0) {
            this.paginationContext.setSortName((ElementNode)this.sortNameComboBox.getItemAt(0));
        }
        if (this.paginationContext.getSortType() != null) {
            this.setSortType(this.paginationContext.getSortType());
        } else if (this.sortTypeComboBox.getItemCount() != 0) {
            this.paginationContext.setSortType((ElementNode)this.sortTypeComboBox.getItemAt(0));
        }
    }

    public void setPaginationEnabled(boolean enabled) {
        this.firstPageButton.setEnabled(enabled);
        this.backwardPageButton.setEnabled(enabled);
        this.forwardPageButton.setEnabled(enabled);
        this.lastPageButton.setEnabled(enabled);
        this.pageIndexDirectTextField.setEnabled(enabled);
        this.pageIndexDirectButton.setEnabled(enabled);
        this.maxPageRowCountDirectTextField.setEnabled(enabled);
        this.maxPageRowCountDirectButton.setEnabled(enabled);
        this.sortNameComboBox.setEnabled(enabled);
        this.sortTypeComboBox.setEnabled(enabled);
        this.submitSortButton.setEnabled(enabled);
    }

    public abstract void directRowIndex(int var1) throws Exception;

    public abstract void directRowCount(int var1) throws Exception;

    public abstract void sort(ElementNode var1, ElementNode var2) throws Exception;

    public abstract void clearRowDatas() throws Exception;
}

