/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private Color shadow = UIManager.getColor("controlShadow");
    private Color darkShadow = Color.black;
    private int size;
    private int direction;

    public ArrowIcon(int size, int direction) {
        this.size = size;
        this.direction = direction;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean isEnabled = c.isEnabled();
        Color oldColor = g.getColor();
        int j = 0;
        this.size = Math.max(this.size, 2);
        int mid = this.size / 2 - 1;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(this.darkShadow);
        } else {
            g.setColor(this.shadow);
        }
        switch (this.direction) {
            case 1: {
                for (int i = 0; i < this.size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                break;
            }
            case 5: {
                j = 0;
                for (int i = this.size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < this.size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                break;
            }
            case 3: {
                j = 0;
                for (int i = this.size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

