/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.config;

import com.nepxion.swing.config.JConfigButtonBar;
import com.nepxion.swing.config.JConfigContentPanel;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.toggle.ITogglePanel;
import com.nepxion.swing.toggle.JToggleActionButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class JConfigBar
extends JPanel {
    private JConfigButtonBar configButtonBar = new JConfigButtonBar();
    private JConfigContentPanel configContentPanel = new JConfigContentPanel();

    public JConfigBar() {
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)new JBasicScrollPane((Component)((Object)this.configButtonBar)), "West");
        this.add((Component)this.configContentPanel, "Center");
        this.setConfigButtonBarWidth(80);
        this.setConfigContentPanelWidth(480);
        this.setHeight(480);
    }

    public void setConfigButtonBarWidth(int configButtonBarWidth) {
        Container configButtonBarContainer = this.configButtonBar.getParent();
        configButtonBarContainer.setPreferredSize(new Dimension(configButtonBarWidth, configButtonBarContainer.getPreferredSize().height));
    }

    public void setConfigContentPanelWidth(int configContentPanelWidth) {
        this.configContentPanel.setPreferredSize(new Dimension(configContentPanelWidth, this.configContentPanel.getPreferredSize().height));
    }

    public void setHeight(int height) {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, height));
    }

    public JConfigButtonBar getConfigButtonBar() {
        return this.configButtonBar;
    }

    public JConfigContentPanel getConfigContentPanel() {
        return this.configContentPanel;
    }

    public ITogglePanel getTogglePanel(String toggleText) {
        Enumeration<AbstractButton> enumeration = this.configButtonBar.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleActionButton toggleActionButton = (JToggleActionButton)enumeration.nextElement();
            ITogglePanel togglePanel = toggleActionButton.getTogglePanel();
            if (!togglePanel.getToggleText().equals(toggleText)) continue;
            return togglePanel;
        }
        return null;
    }

    public JToggleActionButton getToggleActionButton(ITogglePanel togglePanel) {
        Enumeration<AbstractButton> enumeration = this.configButtonBar.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleActionButton toggleActionButton = (JToggleActionButton)enumeration.nextElement();
            if (toggleActionButton.getTogglePanel() != togglePanel) continue;
            return toggleActionButton;
        }
        return null;
    }

    public void addTogglePanel(ITogglePanel togglePanel) {
        JToggleActionButton toggleActionButton = new JToggleActionButton(this.configContentPanel, togglePanel);
        this.configButtonBar.addButton(toggleActionButton);
    }

    public void removeTogglePanel(ITogglePanel togglePanel) {
        JToggleActionButton toggleActionButton = this.getToggleActionButton(togglePanel);
        this.configButtonBar.removeButton(toggleActionButton);
    }

    public void setSelectionTogglePanel(ITogglePanel togglePanel) {
        Enumeration<AbstractButton> enumeration = this.configButtonBar.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleActionButton toggleActionButton = (JToggleActionButton)enumeration.nextElement();
            if (toggleActionButton.getTogglePanel() != togglePanel) continue;
            toggleActionButton.doClick();
            return;
        }
    }

    public void setSelectionTogglePanel(String toggleText) {
        if (toggleText == null) {
            return;
        }
        Enumeration<AbstractButton> enumeration = this.configButtonBar.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleActionButton toggleActionButton = (JToggleActionButton)enumeration.nextElement();
            ITogglePanel togglePanel = toggleActionButton.getTogglePanel();
            if (!togglePanel.getToggleText().equals(toggleText)) continue;
            toggleActionButton.doClick();
            return;
        }
    }

    public void setSelectionTogglePanel(int toggleIndex) {
        if (toggleIndex < 0 || toggleIndex > this.configButtonBar.getButtonGroup().getButtonCount() - 1) {
            return;
        }
        int togglePanelIndex = 0;
        Enumeration<AbstractButton> enumeration = this.configButtonBar.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleActionButton toggleActionButton = (JToggleActionButton)enumeration.nextElement();
            if (togglePanelIndex == toggleIndex) {
                toggleActionButton.doClick();
                return;
            }
            ++togglePanelIndex;
        }
    }
}

