/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ButtonBorder
implements Border {
    public static final int BORDER_RAISED = 0;
    public static final int BORDER_LOWERED = 1;
    private Color brighter = UIManager.getColor("Button.background").brighter();
    private Color darker = UIManager.getColor("Button.background").darker();
    private Color topColor;
    private Color leftColor;
    private Color bottomColor;
    private Color rightColor;

    public ButtonBorder(int borderType) {
        switch (borderType) {
            case 0: {
                this.topColor = this.brighter;
                this.leftColor = this.brighter;
                this.bottomColor = this.darker;
                this.rightColor = this.darker;
                break;
            }
            case 1: {
                this.topColor = this.darker;
                this.leftColor = this.darker;
                this.bottomColor = this.brighter;
                this.rightColor = this.brighter;
            }
        }
    }

    public ButtonBorder(Color topColor, Color leftColor, Color bottomColor, Color rightColor) {
        this.topColor = topColor;
        this.leftColor = leftColor;
        this.bottomColor = bottomColor;
        this.rightColor = rightColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.topColor == null ? 0 : 1, this.leftColor == null ? 0 : 1, this.bottomColor == null ? 0 : 1, this.rightColor == null ? 0 : 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.bottomColor != null) {
            g.setColor(this.bottomColor);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }
        if (this.rightColor != null) {
            g.setColor(this.rightColor);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
        if (this.topColor != null) {
            g.setColor(this.topColor);
            g.drawLine(x, y, x + width - 1, y);
        }
        if (this.leftColor != null) {
            g.setColor(this.leftColor);
            g.drawLine(x, y, x, y + height - 1);
        }
    }
}

