/*
 * Decompiled with CFR 0.152.
 */
package y.layout.random;

import java.awt.Rectangle;
import java.util.Random;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;

public class RandomLayouter
extends CanonicMultiStageLayouter {
    private Rectangle im = new Rectangle(0, 0, 500, 500);

    public RandomLayouter() {
        this.setComponentLayouterEnabled(false);
    }

    public void setLayoutBounds(Rectangle rectangle) {
        this.im = rectangle;
    }

    public Rectangle getLayoutBounds() {
        return this.im;
    }

    public boolean canLayoutCore(LayoutGraph layoutGraph) {
        return true;
    }

    public void doLayoutCore(LayoutGraph layoutGraph) {
        LayoutTool.resetPaths(layoutGraph);
        double d2 = 0.0;
        double d3 = 0.0;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            d2 = Math.max(d2, layoutGraph.getWidth(nodeCursor.node()));
            d3 = Math.max(d3, layoutGraph.getHeight(nodeCursor.node()));
            nodeCursor.next();
        }
        Rectangle rectangle = new Rectangle();
        rectangle.setFrame(this.im.getX() + d2 / 2.0, this.im.getY() + d3 / 2.0, this.im.getWidth() - d2, this.im.getHeight() - d2);
        Random random = new Random();
        NodeCursor nodeCursor2 = layoutGraph.nodes();
        while (nodeCursor2.ok()) {
            YPoint yPoint = new YPoint(random.nextDouble() * rectangle.getWidth() + rectangle.getX(), random.nextDouble() * rectangle.getHeight() + rectangle.getY());
            layoutGraph.setCenter(nodeCursor2.node(), yPoint);
            nodeCursor2.next();
        }
    }
}

