/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import twaver.ShapeNode;
import twaver.TWaverConst;
import twaver.base.A.E.S;
import twaver.base.A.E.b;
import twaver.base.A.E.d;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.NodeSVGUI;

public class ShapeNodeSVGUI
extends NodeSVGUI {
    private ShapeNode V;
    private static final String U = "ShapeNode";

    public ShapeNodeSVGUI(TSVGNetwork network, ShapeNode shapeNode) {
        super(network, shapeNode);
        this.V = shapeNode;
    }

    protected void appendClassName(StringBuffer head) {
        I.B(head, U);
    }

    protected void prepareElementSVGHeader(SVGContext context, StringBuffer head) {
        super.prepareElementSVGHeader(context, head);
        this.appendClassName(head);
        if (this.network.isResizable(this.V)) {
            context.appendShapePoints(head, this.V.getPoints(), 2);
        }
    }

    protected SVGStruct toCustomDrawBodySVG(SVGContext context) {
        Color stateColor;
        StringBuffer sb = new StringBuffer();
        Rectangle bounds = this.element.getBounds();
        Object fillObject = this.getCustomDrawFillObject(context);
        boolean outline3D = this.V.isCustomDrawOutline3D();
        Shape shape = this.V.getShape();
        String id = I.A(context, shape);
        float alpha = this.getRenderAlpha();
        Stroke stroke = b.F(this.element, "custom.draw.outline.stroke");
        float lineWidth = 1.0f;
        if (!(stroke instanceof BasicStroke)) {
            stroke = TWaverConst.DOUBLE_WIDTH_STROKE;
        } else {
            lineWidth = ((BasicStroke)stroke).getLineWidth();
        }
        if (outline3D) {
            lineWidth += 2.0f;
        }
        if (this.network.isSelectable(this.V)) {
            I.A(sb, id);
            I.B(sb);
            I.C(sb);
            I.A(context, sb, null, (Object)this.V.getBorderColor(), "" + (lineWidth + 3.0f), alpha).append("/>\n");
        }
        if ((stateColor = this.getStateOutlineColor()) != null) {
            I.A(sb, id);
            I.A(context, sb, null, (Object)stateColor, d.A((int)lineWidth, stroke), alpha).append("/>\n");
        }
        Color outlineColor = null;
        if (this.V.isCustomDrawOutline()) {
            outlineColor = this.V.getCustomDrawOutlineColor();
            outlineColor = this.getPaintBodyColor(outlineColor);
            if (outline3D) {
                I.A(sb, id);
                Color color = outlineColor.brighter().brighter();
                I.A(context, sb, null, (Object)color, stroke, alpha);
                I.A(sb, -1, -1).append("/>\n");
                I.A(sb, id);
                color = outlineColor.darker().darker();
                I.A(context, sb, null, (Object)color, stroke, alpha);
                I.A(sb, 1, 1).append("/>\n");
            }
        }
        I.A(sb, id);
        I.A(context, sb, fillObject, (Object)outlineColor, stroke, alpha).append("/>\n");
        this.toArrowSVG(context, sb, shape, bounds);
        return new SVGStruct(sb.toString(), bounds);
    }

    protected void toArrowSVG(SVGContext context, StringBuffer sb, Shape shape, Rectangle bounds) {
        boolean fromArrow = this.V.isShapeNodeFromArrow();
        boolean toArrow = this.V.isShapeNodeToArrow();
        if (shape instanceof GeneralPath) {
            Color outlineObject;
            Color fillObject;
            int yOffset;
            int xOffset;
            int style;
            GeneralPath path = (GeneralPath)shape;
            if (fromArrow) {
                style = this.V.getShapeNodeFromArrowStyle();
                xOffset = this.V.getShapeNodeFromArrowXOffset();
                yOffset = this.V.getShapeNodeFromArrowYOffset();
                Shape fromShape = S.A(path, bounds, style, xOffset, yOffset);
                fillObject = this.V.getShapeNodeFromArrowColor();
                outlineObject = null;
                if (this.V.isShapeNodeFromArrowOutline()) {
                    outlineObject = this.V.getShapeNodeFromArrowOutlineColor();
                }
                I.A(context, sb, fromShape, (Object)fillObject, (Object)outlineObject, (Object)"1", 1.0f, 0.0, null);
            }
            if (toArrow) {
                style = this.V.getShapeNodeToArrowStyle();
                xOffset = this.V.getShapeNodeToArrowXOffset();
                yOffset = this.V.getShapeNodeToArrowYOffset();
                Shape toShape = S.B(path, bounds, style, xOffset, yOffset);
                fillObject = this.V.getShapeNodeToArrowColor();
                outlineObject = null;
                if (this.V.isShapeNodeToArrowOutline()) {
                    outlineObject = this.V.getShapeNodeToArrowOutlineColor();
                }
                I.A(context, sb, toShape, (Object)fillObject, (Object)outlineObject, (Object)"1", 1.0f, 0.0, null);
            }
        }
    }
}

