/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import twaver.base.A.E.P;

public class ActionTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    protected final TableCellRenderer renderer;
    protected final Component component;
    protected JButton actionButton;
    protected final JButton clearButton;
    protected final JPanel mainPanel;
    protected boolean isClear = false;
    protected Object value;
    protected JTable table;
    protected int row;
    protected int column;
    protected int clickCountToStart = 1;

    public ActionTableCellEditor(Object rendererOrComponent) {
        this(rendererOrComponent, false);
    }

    public ActionTableCellEditor(Object rendererOrComponent, boolean enableDoubleClickOnRenderer) {
        this(rendererOrComponent, true, false);
        if (enableDoubleClickOnRenderer && this.component != null) {
            this.component.addMouseListener(new MouseAdapter(){
                ActionEvent A;
                {
                    this.A = new ActionEvent(ActionTableCellEditor.this.actionButton, 0, null);
                }

                public void mouseClicked(MouseEvent e2) {
                    if (e2.getClickCount() >= 2) {
                        ActionTableCellEditor.this.actionPerformed(this.A);
                    }
                }
            });
        }
    }

    public ActionTableCellEditor(Object rendererOrComponent, boolean isActionable, boolean isClearable) {
        if (rendererOrComponent instanceof TableCellRenderer) {
            this.renderer = (TableCellRenderer)rendererOrComponent;
            this.component = null;
        } else if (rendererOrComponent instanceof Component) {
            this.renderer = null;
            this.component = (Component)rendererOrComponent;
        } else {
            throw new IllegalArgumentException("rendererOrComponent must be an instance of Component or TableCellRenderer");
        }
        if (isActionable) {
            this.actionButton = P.D();
            this.actionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    ActionTableCellEditor.this.actionPerformed(e2);
                    if (ActionTableCellEditor.this.table != null) {
                        ActionTableCellEditor.this.table.requestFocus();
                    }
                }
            });
        } else {
            this.actionButton = null;
        }
        if (isClearable) {
            this.clearButton = P.A();
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    ActionTableCellEditor.this.clearPerformed();
                }
            });
        } else {
            this.clearButton = null;
        }
        this.mainPanel = new JPanel(new BorderLayout());
        if (this.component != null) {
            this.mainPanel.add(this.component, "Center");
            if (this.component instanceof JComponent) {
                ((JComponent)this.component).setFocusCycleRoot(true);
            }
        }
        if (this.actionButton != null && this.clearButton != null) {
            JPanel buttonPane = new JPanel(new GridLayout(1, 2));
            buttonPane.add(this.actionButton);
            buttonPane.add(this.clearButton);
            this.mainPanel.add((Component)buttonPane, "East");
        } else if (this.actionButton != null) {
            this.mainPanel.add((Component)this.actionButton, "East");
        } else if (this.clearButton != null) {
            this.mainPanel.add((Component)this.clearButton, "East");
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.isClear = false;
        this.value = value;
        this.table = table;
        this.row = row;
        this.column = column;
        if (this.renderer != null) {
            Component rendererComp = this.renderer.getTableCellRendererComponent(table, value, true, isSelected, row, column);
            this.mainPanel.add(rendererComp, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ActionTableCellEditor.this.mainPanel.repaint();
                }
            });
        }
        if (this.component != null) {
            this.setComponentValue();
        }
        return this.mainPanel;
    }

    public Window getWindow() {
        return P.B(this.table);
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setComponentValue() {
    }

    public void clearPerformed() {
        this.isClear = true;
        this.value = null;
        this.stopCellEditing();
        this.table.requestFocus();
    }

    public Object getCellEditorValue() {
        if (this.isClear) {
            return null;
        }
        return this.value;
    }

    public void actionPerformed(ActionEvent e2) {
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public JButton getActionButton() {
        return this.actionButton;
    }

    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    public JTable getTable() {
        return this.table;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public Component getComponent() {
        return this.component;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }
}

