/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.gradient;

import com.nepxion.swing.gradient.JTexturePainter;
import com.nepxion.swing.style.texture.ITextureStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import javax.swing.ImageIcon;

public class JBackgroundPainter {
    public static void paintBackground(Component c, Graphics g, ITextureStyle textureStyle) {
        ImageIcon backgroundImageIcon = textureStyle.getBackgroundImageIcon();
        ImageIcon backgroundLeftImageIcon = textureStyle.getBackgroundLeftImageIcon();
        ImageIcon backgroundRightImageIcon = textureStyle.getBackgroundRightImageIcon();
        JBackgroundPainter.paintBackground(c, g, backgroundImageIcon, backgroundLeftImageIcon, backgroundRightImageIcon);
    }

    public static void paintBackground(Component c, Graphics g, ImageIcon backgroundImageIcon) {
        JBackgroundPainter.paintBackground(c, g, JTexturePainter.getCacheTexturePaint(backgroundImageIcon.getImage()));
    }

    public static void paintBackground(Component c, Graphics g, TexturePaint backgroundTexturePaint) {
        JBackgroundPainter.paintBackground(c, g, backgroundTexturePaint, null, null);
    }

    public static void paintBackground(Component c, Graphics g, ImageIcon backgroundImageIcon, ImageIcon backgroundLeftImageIcon, ImageIcon backgroundRightImageIcon) {
        JBackgroundPainter.paintBackground(c, g, JTexturePainter.getCacheTexturePaint(backgroundImageIcon.getImage()), backgroundLeftImageIcon, backgroundRightImageIcon);
    }

    public static void paintBackground(Component c, Graphics g, TexturePaint backgroundTexturePaint, ImageIcon backgroundLeftImageIcon, ImageIcon backgroundRightImageIcon) {
        Graphics2D g2d = (Graphics2D)g;
        int width = c.getWidth();
        int height = c.getHeight();
        g2d.setPaint(backgroundTexturePaint);
        g2d.fillRect(0, 0, width, height);
        if (backgroundLeftImageIcon != null) {
            g2d.drawImage(backgroundLeftImageIcon.getImage(), 0, 0, null);
        }
        if (backgroundRightImageIcon != null) {
            int x = width - backgroundRightImageIcon.getImage().getWidth(null);
            int y = 0;
            g2d.drawImage(backgroundRightImageIcon.getImage(), x, y, null);
        }
    }
}

