/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.panel;

import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.textfield.JBasicPasswordField;
import com.nepxion.swing.validation.IValidation;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JPasswordPanel
extends JPanel
implements IValidation {
    private JBasicPasswordField oldPasswordTextField = new JBasicPasswordField();
    private JBasicPasswordField newPasswordTextField = new JBasicPasswordField();
    private JBasicPasswordField newPasswordConfirmTextField = new JBasicPasswordField();

    public JPasswordPanel() {
        double[][] size = new double[][]{{-2.0, 160.0}, {-2.0, -2.0, -2.0}};
        TableLayout tableLayout = new TableLayout(size);
        tableLayout.setVGap(5);
        tableLayout.setHGap(5);
        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(tableLayout);
        passwordPanel.add((Component)new JLabel(SwingLocale.getString("old_password")), "0, 0");
        passwordPanel.add((Component)this.oldPasswordTextField, "1, 0");
        passwordPanel.add((Component)new JLabel(SwingLocale.getString("new_password")), "0, 1");
        passwordPanel.add((Component)this.newPasswordTextField, "1, 1");
        passwordPanel.add((Component)new JLabel(SwingLocale.getString("new_password_confirm")), "0, 2");
        passwordPanel.add((Component)this.newPasswordConfirmTextField, "1, 2");
        this.setLayout(new FiledLayout(0, 0, 5));
        this.add(passwordPanel);
    }

    public JBasicPasswordField getOldPasswordTextField() {
        return this.oldPasswordTextField;
    }

    public JBasicPasswordField getNewPasswordTextField() {
        return this.newPasswordTextField;
    }

    public JBasicPasswordField getNewPasswordConfirmTextField() {
        return this.newPasswordConfirmTextField;
    }

    @Override
    public boolean verify() {
        String oldPassword = this.oldPasswordTextField.getPasswordText().toString();
        if (oldPassword.equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("old_password_not_null"), SwingLocale.getString("warning"), 2);
            return false;
        }
        String newPassword = this.newPasswordTextField.getPasswordText().toString();
        if (newPassword.equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("new_password_not_null"), SwingLocale.getString("warning"), 2);
            return false;
        }
        String newPasswordConfirm = this.newPasswordConfirmTextField.getPasswordText().toString();
        if (newPasswordConfirm.equals("")) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("new_password_confirm_not_null"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (!newPassword.equals(newPasswordConfirm)) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("new_password_not_matched"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }
}

