/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.splash;

import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.listener.DisplayAbilityListener;
import com.nepxion.swing.panel.JCaptionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JCaptionSplash
extends JPanel {
    private JCaptionPanel captionPanel;

    public JCaptionSplash(Icon splashIcon, Color splashColor, int[] captionStartPosition, int[] captionSize, String[] caption) {
        JLabel label = new JLabel(splashIcon);
        this.captionPanel = new JCaptionPanel();
        this.captionPanel.setForeground(splashColor);
        this.captionPanel.setCaption(caption);
        this.captionPanel.setAutoAdaptSize(true);
        this.captionPanel.setOpaque(false);
        this.captionPanel.setSpeed(50);
        double[][] size = new double[][]{{captionStartPosition[0], captionSize[0], -1.0}, {captionStartPosition[1], captionSize[1], -1.0}};
        this.setBorder(BorderFactory.createLineBorder(new Color(121, 121, 121)));
        this.setLayout(new TableLayout(size));
        this.add((Component)this.captionPanel, "1, 1");
        this.add((Component)label, "0, 0, 2, 2");
        this.captionPanel.addHierarchyListener(new DisplayAbilityListener(){

            @Override
            public void displayAbilityChanged(HierarchyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JCaptionSplash.this.captionPanel.isShowing()) {
                            JCaptionSplash.this.captionPanel.start();
                        } else {
                            JCaptionSplash.this.captionPanel.stop();
                        }
                    }
                });
            }
        });
    }

    public void start() {
        this.captionPanel.start();
    }

    public void stop() {
        this.captionPanel.stop();
    }

    public JCaptionPanel getCaptionPanel() {
        return this.captionPanel;
    }
}

