/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.renderer.list;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;

public class TabbedListCellRenderer
extends DefaultListCellRenderer {
    private int width = 0;
    private String tabDelimiter = "\t";
    private int[] tabSizes = null;
    private int defaultTabSize = 50;

    public TabbedListCellRenderer() {
        this("\t");
    }

    public TabbedListCellRenderer(int[] tabSizes) {
        this(tabSizes, 50);
    }

    public TabbedListCellRenderer(String tabDelimiter) {
        this(tabDelimiter, null);
    }

    public TabbedListCellRenderer(int width) {
        this(width, 50);
    }

    public TabbedListCellRenderer(int[] tabSizes, int defaultTabSize) {
        this("\t", tabSizes, defaultTabSize);
    }

    public TabbedListCellRenderer(String tabDelimiter, int defaultTabSize) {
        this(tabDelimiter, (int[])null, defaultTabSize);
    }

    public TabbedListCellRenderer(String tabDelimiter, int[] tabSizes) {
        this(tabDelimiter, tabSizes, 50);
    }

    public TabbedListCellRenderer(int width, int defaultTabSize) {
        this(width, (String)null, defaultTabSize);
    }

    public TabbedListCellRenderer(int width, int[] tabSizes) {
        this(width, tabSizes, 50);
    }

    public TabbedListCellRenderer(int width, String tabDelimiter) {
        this(width, tabDelimiter, 50);
    }

    public TabbedListCellRenderer(String tabDelimiter, int[] tabSizes, int defaultTabSize) {
        this(-1, tabDelimiter, tabSizes, defaultTabSize);
    }

    public TabbedListCellRenderer(int width, int[] tabSizes, int defaultTabSize) {
        this(width, "\t", tabSizes, defaultTabSize);
    }

    public TabbedListCellRenderer(int width, String tabDelimiter, int defaultTabSize) {
        this(width, tabDelimiter, null, defaultTabSize);
    }

    public TabbedListCellRenderer(int width, String tabDelimiter, int[] tabSizes) {
        this(width, tabDelimiter, tabSizes, 50);
    }

    public TabbedListCellRenderer(int width, String tabDelimiter, int[] tabSizes, int defaultTabSize) {
        this.width = width;
        this.tabDelimiter = tabDelimiter;
        this.tabSizes = tabSizes;
        this.defaultTabSize = defaultTabSize;
    }

    public String getTabDelimiter() {
        return this.tabDelimiter;
    }

    public void setTabDelimiter(String tabDelimiter) {
        this.tabDelimiter = tabDelimiter;
    }

    public int[] getTabSizes() {
        return this.tabSizes;
    }

    public void setTabSizes(int[] tabSizes) {
        this.tabSizes = tabSizes;
    }

    public int getDefaultTabSize() {
        return this.defaultTabSize;
    }

    public void setDefaultTabSize(int defaultTabSize) {
        this.defaultTabSize = defaultTabSize;
    }

    public int getTabSize(int index) {
        if (this.tabSizes == null) {
            return this.defaultTabSize * index;
        }
        int length = this.tabSizes.length;
        if (index >= 0 && index < length) {
            return this.tabSizes[index];
        }
        return this.tabSizes[length - 1] + this.defaultTabSize * (index - length + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(this.width > 0 ? this.width : preferredSize.width, preferredSize.height);
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top + fontMetrics.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), this.tabDelimiter);
        while (stringTokenizer.hasMoreTokens()) {
            String next = stringTokenizer.nextToken();
            g.drawString(next, x, y);
            if (!stringTokenizer.hasMoreTokens()) break;
            int index = 0;
            while (x >= this.getTabSize(index)) {
                ++index;
            }
            x = this.getTabSize(index);
        }
    }
}

