/*
 * Decompiled with CFR 0.152.
 */
package twaver.combobox;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import twaver.Element;
import twaver.Generator;
import twaver.combobox.TComboBox;

public class TComboBoxRenderer
extends DefaultListCellRenderer {
    private TComboBox A;
    private boolean B;

    public TComboBoxRenderer(TComboBox combobox) {
        this.A = combobox;
    }

    public Component getListCellRendererComponent(JList list, Object value, int rowIndex, boolean isSelected, boolean isCellHasFocus) {
        if (value == null) {
            return super.getListCellRendererComponent((JList<?>)list, value, rowIndex, isSelected, isCellHasFocus);
        }
        Element element = (Element)value;
        super.getListCellRendererComponent((JList<?>)list, value, rowIndex, isSelected, isCellHasFocus);
        this.setIcon(null);
        this.setText(null);
        this.setToolTipText(null);
        if (this.A.isIconVisible()) {
            this.setIcon(this.getIcon(element));
        }
        this.setText(this.getText(element));
        this.setToolTipText(this.getToolTipText(element));
        return this;
    }

    protected String getToolTipText(Element element) {
        Generator generator = this.A.getElementToolTipTextGenerator();
        if (generator == null) {
            String text = element.getToolTipText();
            if (text == null) {
                return element.getName();
            }
            return text;
        }
        return (String)generator.generate(element);
    }

    protected Icon getIcon(Element element) {
        Generator generator = this.A.getElementIconGenerator();
        if (generator == null) {
            return element.getIcon();
        }
        return (Icon)generator.generate(element);
    }

    protected String getText(Element element) {
        Generator generator = this.A.getElementLabelGenerator();
        if (generator == null) {
            return element.getName();
        }
        return (String)generator.generate(element);
    }

    public void setCenterAlignment(boolean isCenterAlignment) {
        this.B = isCenterAlignment;
        if (this.B) {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
        } else {
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(11);
            this.setVerticalTextPosition(0);
        }
        this.A.updateUI();
    }

    public boolean isCenterAlignment() {
        return this.B;
    }
}

